/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_07_Get_File_Info {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleId;
    static int assetId;
    static String assetType;
    private static final String LOOKUP_KEY = "ORIGINAL";
    private static final String UID = "01CM07";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
        assetId = utilApi.getAssetId(titleId, assetType);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_07_Get_File_Info testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_07_Get_File_Info testEmptyTitleId - FileUri : " + this.response.get("fileUri")));
        logger.debug((Object)("Test_07_Get_File_Info testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileUri"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "-1");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_07_Get_File_Info testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_07_Get_File_Info testNegativeTitleId - FileUri : " + this.response.get("fileUri")));
        logger.debug((Object)("Test_07_Get_File_Info testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileUri"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "abcd");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_07_Get_File_Info testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_07_Get_File_Info testStringAsTitleId - FileUri : " + this.response.get("fileUri")));
        logger.debug((Object)("Test_07_Get_File_Info testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileUri"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "");
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_07_Get_File_Info testEmptyAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_07_Get_File_Info testEmptyAssetId - FileUri : " + this.response.get("fileUri")));
        logger.debug((Object)("Test_07_Get_File_Info testEmptyAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileUri"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "-1");
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_07_Get_File_Info testNegativeAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_07_Get_File_Info testNegativeAssetId - FileUri : " + this.response.get("fileUri")));
        logger.debug((Object)("Test_07_Get_File_Info testNegativeAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileUri"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "abcd");
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_07_Get_File_Info testStringAsAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_07_Get_File_Info testStringAsAssetId - FileUri : " + this.response.get("fileUri")));
        logger.debug((Object)("Test_07_Get_File_Info testStringAsAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileUri"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyLookupKey() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", "");
        logger.debug((Object)"Test_07_Get_File_Info testEmptyLookupKey Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_07_Get_File_Info testEmptyLookupKey - FileUri : " + this.response.get("fileUri")));
        logger.debug((Object)("Test_07_Get_File_Info testEmptyLookupKey - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileUri"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidLookupKey() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", "abcd1234");
        logger.debug((Object)"Test_07_Get_File_Info testInvalidLookupKey Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_07_Get_File_Info testInvalidLookupKey - FileUri : " + this.response.get("fileUri")));
        logger.debug((Object)("Test_07_Get_File_Info testInvalidLookupKey - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileUri"));
    }

    static {
        msgOrigin = "171219";
        assetType = "POSTER";
        logger = Logger.getLogger(Test_07_Get_File_Info.class);
    }
}

