/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_38_Update_Title_for_Package {
    static SoapCaller soapCaller;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    static UtilApi utilApi;
    static int titleId;
    Map<String, String> params;
    Map<String, Object> response;
    private static final String UID = "01CM38";
    private static final String METADATA_PATH = "/opt/tandbergtv/cms/workflow/lib/content-management-template/NewMetaData/ADI.XML";
    private static final String ASSET_FOLDER_PATH = "/opt/tandbergtv/cms/workflow/lib/content-management-template/NewMetaData";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        utilApi = new UtilApi();
        titleId = utilApi.createTitleForMetadata();
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyMetadataPath() throws Exception {
        this.params.put("metadataPath", "");
        this.params.put("assetFolderPath", ASSET_FOLDER_PATH);
        this.params.put("titleId", String.valueOf(titleId));
        logger.debug((Object)"Test_38_Update_Title_for_Package testEmptyMetadataPath Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " TitleId -> " + this.params.get("titleId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_38_Update_Title_for_Package testEmptyMetadataPath - Metadata AssetId : " + this.response.get("metadataAssetId")));
        logger.debug((Object)("Test_38_Update_Title_for_Package testEmptyMetadataPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("metadataAssetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidMetadataPath() throws Exception {
        this.params.put("metadataPath", "abcd1234");
        this.params.put("assetFolderPath", ASSET_FOLDER_PATH);
        this.params.put("titleId", String.valueOf(titleId));
        logger.debug((Object)"Test_38_Update_Title_for_Package testInvalidMetadataPath Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " TitleId -> " + this.params.get("titleId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_38_Update_Title_for_Package testInvalidMetadataPath - Metadata AssetId : " + this.response.get("metadataAssetId")));
        logger.debug((Object)("Test_38_Update_Title_for_Package testInvalidMetadataPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("metadataAssetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyAssetFolderPath() throws Exception {
        this.params.put("metadataPath", METADATA_PATH);
        this.params.put("assetFolderPath", "");
        this.params.put("titleId", String.valueOf(titleId));
        logger.debug((Object)"Test_38_Update_Title_for_Package testEmptyAssetFolderPath Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " TitleId -> " + this.params.get("titleId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_38_Update_Title_for_Package testEmptyAssetFolderPath - Metadata AssetId : " + this.response.get("metadataAssetId")));
        logger.debug((Object)("Test_38_Update_Title_for_Package testEmptyAssetFolderPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("metadataAssetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInvalidAssetFolderPath() throws Exception {
        this.params.put("metadataPath", METADATA_PATH);
        this.params.put("assetFolderPath", "abcd1234");
        this.params.put("titleId", String.valueOf(titleId));
        logger.debug((Object)"Test_38_Update_Title_for_Package testInvalidAssetFolderPath Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " TitleId -> " + this.params.get("titleId")));
        Assert.assertTrue((titleId > 0 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_38_Update_Title_for_Package testInvalidAssetFolderPath - Metadata AssetId : " + this.response.get("metadataAssetId")));
        logger.debug((Object)("Test_38_Update_Title_for_Package testInvalidAssetFolderPath - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("metadataAssetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("metadataPath", METADATA_PATH);
        this.params.put("assetFolderPath", ASSET_FOLDER_PATH);
        this.params.put("titleId", "");
        logger.debug((Object)"Test_38_Update_Title_for_Package testEmptyTitleId Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " TitleId -> " + this.params.get("titleId")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_38_Update_Title_for_Package testEmptyTitleId - Metadata AssetId : " + this.response.get("metadataAssetId")));
        logger.debug((Object)("Test_38_Update_Title_for_Package testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("metadataAssetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("metadataPath", METADATA_PATH);
        this.params.put("assetFolderPath", ASSET_FOLDER_PATH);
        this.params.put("titleId", "-1");
        logger.debug((Object)"Test_38_Update_Title_for_Package testNegativeTitleId Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " TitleId -> " + this.params.get("titleId")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_38_Update_Title_for_Package testNegativeTitleId - Metadata AssetId : " + this.response.get("metadataAssetId")));
        logger.debug((Object)("Test_38_Update_Title_for_Package testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("metadataAssetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("metadataPath", METADATA_PATH);
        this.params.put("assetFolderPath", ASSET_FOLDER_PATH);
        this.params.put("titleId", "abcd");
        logger.debug((Object)"Test_38_Update_Title_for_Package testStringAsTitleId Request Params");
        logger.debug((Object)("Metadata Path -> " + this.params.get("metadataPath") + " AssetFolder Path -> " + this.params.get("assetFolderPath") + " TitleId -> " + this.params.get("titleId")));
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_38_Update_Title_for_Package testStringAsTitleId - Metadata AssetId : " + this.response.get("metadataAssetId")));
        logger.debug((Object)("Test_38_Update_Title_for_Package testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("metadataAssetId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171381";
        logger = Logger.getLogger(Test_38_Update_Title_for_Package.class);
    }
}

