/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.content;

import com.ericsson.cms.devices.content.SoapCaller;
import com.ericsson.cms.devices.content.UtilApi;
import com.tandbergtv.workflow.message.IMessageKey;
import com.tandbergtv.workflow.message.MessageKeyImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_74_Get_File_Properties_by_LookUp_Key {
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    static String msgOrigin;
    static MessageKeyImpl messageKey;
    static IMessageKey messageOrigin;
    Map<String, String> params;
    Map<String, Object> response;
    static int titleId;
    static int assetId;
    static String assetType;
    private static final String LOOKUP_KEY = "ORIGINAL";
    private static final String UID = "01CM74";
    private static Logger logger;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        utilApi = new UtilApi();
        messageKey = new MessageKeyImpl((Object)msgOrigin);
        messageOrigin = messageKey;
        titleId = utilApi.createTitleForMetadata();
        assetId = utilApi.getAssetId(titleId, assetType);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utilApi.deleteMasterTitle(titleId);
        utilApi = null;
        soapCaller = null;
        messageKey = null;
        messageOrigin = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.params.put("titleId", "");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_74_Get_File_Properties_by_LookUp_Key testEmptyTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testEmptyTitleId - FileId : " + this.response.get("fileId")));
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testEmptyTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.params.put("titleId", "-1");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_74_Get_File_Properties_by_LookUp_Key testNegativeTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testNegativeTitleId - FileId : " + this.response.get("fileId")));
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testNegativeTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.params.put("titleId", "abcd");
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_74_Get_File_Properties_by_LookUp_Key testStringAsTitleId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testStringAsTitleId - FileId : " + this.response.get("fileId")));
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testStringAsTitleId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "");
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_74_Get_File_Properties_by_LookUp_Key testEmptyAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testEmptyAssetId - FileId : " + this.response.get("fileId")));
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testEmptyAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "-1");
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_74_Get_File_Properties_by_LookUp_Key testNegativeAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testNegativeAssetId - FileId : " + this.response.get("fileId")));
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testNegativeAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsAssetId() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", "abcd");
        this.params.put("lookupKey", LOOKUP_KEY);
        logger.debug((Object)"Test_74_Get_File_Properties_by_LookUp_Key testStringAsAssetId Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testStringAsAssetId - FileId : " + this.response.get("fileId")));
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testStringAsAssetId - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyLookupKey() throws Exception {
        this.params.put("titleId", String.valueOf(titleId));
        this.params.put("assetId", String.valueOf(assetId));
        this.params.put("lookupKey", "");
        logger.debug((Object)"Test_74_Get_File_Properties_by_LookUp_Key testEmptyLookupKey Request Params");
        logger.debug((Object)("TitleID -> " + this.params.get("titleId") + " AssetId -> " + this.params.get("assetId") + " LookupKey ->  " + this.params.get("lookupKey")));
        Assert.assertTrue((titleId > 1 ? 1 : 0) != 0);
        Assert.assertTrue((assetId > 1 ? 1 : 0) != 0);
        this.response = soapCaller.invokeApi(UID, messageOrigin, this.params);
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testEmptyLookupKey - FileId : " + this.response.get("fileId")));
        logger.debug((Object)("Test_74_Get_File_Properties_by_LookUp_Key testEmptyLookupKey - Error Message : " + this.response.get("error-message")));
        Assert.assertNull((Object)this.response.get("fileId"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    static {
        msgOrigin = "171219";
        assetType = "POSTER";
        logger = Logger.getLogger(Test_74_Get_File_Properties_by_LookUp_Key.class);
    }
}

