/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SoapCaller;
import com.ericsson.cms.devices.sites.TestCreateSiteTitle;
import com.ericsson.cms.devices.sites.UtilApi;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestExportSiteTitles {
    static String destUrl;
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    String UID;
    Map<String, String> params;
    Map<String, Object> response;
    private Logger logger = Logger.getLogger(TestCreateSiteTitle.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        destUrl = soapCaller.getUrl();
        utilApi = new UtilApi(destUrl);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.UID = null;
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        destUrl = null;
        soapCaller = null;
        utilApi = null;
    }

    @Test
    public void testEmptySiteId() throws Exception {
        this.UID = "01SM13";
        this.params.put("IncludeInProgress", "true");
        this.params.put("IncludeDistributed", "true");
        this.params.put("IncludeReadyForDistribution", "true");
        this.params.put("IncludeFailed", "true");
        this.params.put("IncludeTargeted", "true");
        this.params.put("FilePath", "C:/content/unmapped/tempnew.csv");
        this.params.put("SiteID", "");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestExportSiteTitles EmptySiteId: OutputFilePath -" + this.response.get("OutputFilePath") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("OutputFilePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeSiteId() throws Exception {
        this.UID = "01SM13";
        this.params.put("IncludeInProgress", "true");
        this.params.put("IncludeDistributed", "true");
        this.params.put("IncludeReadyForDistribution", "true");
        this.params.put("IncludeFailed", "true");
        this.params.put("IncludeTargeted", "true");
        this.params.put("FilePath", "C:/content/unmapped/tempnew.csv");
        this.params.put("SiteID", "-20");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestExportSiteTitles NegativeSiteId: OutputFilePath -" + this.response.get("OutputFilePath") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("OutputFilePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsSiteId() throws Exception {
        this.UID = "01SM13";
        this.params.put("IncludeInProgress", "true");
        this.params.put("IncludeDistributed", "true");
        this.params.put("IncludeReadyForDistribution", "true");
        this.params.put("IncludeFailed", "true");
        this.params.put("IncludeTargeted", "true");
        this.params.put("FilePath", "C:/content/unmapped/tempnew.csv");
        this.params.put("SiteID", "Abcd");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestExportSiteTitles NegativeSiteId: OutputFilePath -" + this.response.get("OutputFilePath") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("OutputFilePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testInActiveSite() throws Exception {
        int sId = utilApi.getSiteId("TestLogicalSite");
        Assert.assertTrue((sId > 0 ? 1 : 0) != 0);
        this.logger.debug((Object)("TestExportSiteTitles InActiveSite: SiteId - " + sId));
        this.UID = "01SM13";
        this.params.put("IncludeInProgress", "true");
        this.params.put("IncludeDistributed", "true");
        this.params.put("IncludeReadyForDistribution", "true");
        this.params.put("IncludeFailed", "true");
        this.params.put("IncludeTargeted", "true");
        this.params.put("FilePath", "C:/content/unmapped/tempnew.csv");
        this.params.put("SiteID", String.valueOf(sId));
        this.logger.debug((Object)("TestExportSiteTitles-Deactivating the Site : SiteID " + sId));
        utilApi.deactivateSite(sId);
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestExportSiteTitles NegativeSiteId: OutputFilePath -" + this.response.get("OutputFilePath") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("OutputFilePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
        this.logger.debug((Object)("TestExportSiteTitles-Activating back the Site : SiteID " + sId));
        utilApi.activateSite(sId);
    }

    @Test
    public void testEmptyIncludeInProgress() throws Exception {
        int sId = utilApi.getSiteId("TestLogicalSite");
        Assert.assertTrue((sId > 0 ? 1 : 0) != 0);
        this.logger.debug((Object)("TestExportSiteTitles EmptyIncludeInProgress: SiteId - " + sId));
        this.UID = "01SM13";
        this.params.put("IncludeInProgress", "");
        this.params.put("IncludeDistributed", "true");
        this.params.put("IncludeReadyForDistribution", "true");
        this.params.put("IncludeFailed", "true");
        this.params.put("IncludeTargeted", "true");
        this.params.put("FilePath", "C:/content/unmapped/tempnew.csv");
        this.params.put("SiteID", String.valueOf(sId));
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestExportSiteTitles EmptyIncludeInProgress: OutputFilePath -" + this.response.get("OutputFilePath") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("OutputFilePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyIncludeDistributed() throws Exception {
        this.UID = "01SM13";
        this.params.put("IncludeInProgress", "true");
        this.params.put("IncludeDistributed", "");
        this.params.put("IncludeReadyForDistribution", "true");
        this.params.put("IncludeFailed", "true");
        this.params.put("IncludeTargeted", "true");
        this.params.put("FilePath", "C:/content/unmapped/tempnew.csv");
        this.params.put("SiteID", "161");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestExportSiteTitles testEmptyIncludeDistributed: OutputFilePath -" + this.response.get("OutputFilePath") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("OutputFilePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyIncludeReadyForDistribution() throws Exception {
        this.UID = "01SM13";
        this.params.put("IncludeInProgress", "true");
        this.params.put("IncludeDistributed", "true");
        this.params.put("IncludeReadyForDistribution", "");
        this.params.put("IncludeFailed", "true");
        this.params.put("IncludeTargeted", "true");
        this.params.put("FilePath", "C:/content/unmapped/tempnew.csv");
        this.params.put("SiteID", "161");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestExportSiteTitles testEmptyIncludeReadyForDistribution: OutputFilePath -" + this.response.get("OutputFilePath") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("OutputFilePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyIncludeFailed() throws Exception {
        this.UID = "01SM13";
        this.params.put("IncludeInProgress", "true");
        this.params.put("IncludeDistributed", "true");
        this.params.put("IncludeReadyForDistribution", "true");
        this.params.put("IncludeFailed", "");
        this.params.put("IncludeTargeted", "true");
        this.params.put("FilePath", "C:/content/unmapped/tempnew.csv");
        this.params.put("SiteID", "161");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestExportSiteTitles testEmptyIncludeFailed: OutputFilePath -" + this.response.get("OutputFilePath") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("OutputFilePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testEmptyIncludeTargeted() throws Exception {
        this.UID = "01SM13";
        this.params.put("IncludeInProgress", "true");
        this.params.put("IncludeDistributed", "true");
        this.params.put("IncludeReadyForDistribution", "true");
        this.params.put("IncludeFailed", "true");
        this.params.put("IncludeTargeted", "");
        this.params.put("FilePath", "C:/content/unmapped/tempnew.csv");
        this.params.put("SiteID", "161");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestExportSiteTitles testEmptyIncludeTargeted: OutputFilePath -" + this.response.get("OutputFilePath") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("OutputFilePath"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }
}

