/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.devices.sites;

import com.ericsson.cms.devices.sites.SoapCaller;
import com.ericsson.cms.devices.sites.TestCreateSiteTitle;
import com.ericsson.cms.devices.sites.UtilApi;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGetSiteTitles {
    static String destUrl;
    static SoapCaller soapCaller;
    static UtilApi utilApi;
    String UID;
    Map<String, String> params;
    Map<String, Object> response;
    private Logger logger = Logger.getLogger(TestCreateSiteTitle.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        soapCaller = new SoapCaller();
        destUrl = soapCaller.getUrl();
        utilApi = new UtilApi(destUrl);
    }

    @Before
    public void setUp() throws Exception {
        this.params = new HashMap<String, String>();
        this.response = new HashMap<String, Object>();
    }

    @After
    public void tearDown() throws Exception {
        this.UID = null;
        this.params = null;
        this.response = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        destUrl = null;
        soapCaller = null;
        utilApi = null;
    }

    @Test
    public void testEmptyTitleId() throws Exception {
        this.UID = "01SM07";
        this.params.put("TitleID", "");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGetSiteTitles EmptyTitleId: SiteTitleIds -" + this.response.get("SiteTitleIDs") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("SiteTitleIDs"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testNegativeTitleId() throws Exception {
        this.UID = "01SM07";
        this.params.put("TitleID", "-25");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGetSiteTitles NegativeTitleId: SiteTitleIds -" + this.response.get("SiteTitleIDs") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("SiteTitleIDs"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }

    @Test
    public void testStringAsTitleId() throws Exception {
        this.UID = "01SM07";
        this.params.put("TitleID", "abc$+9");
        this.response = soapCaller.invokeApi(this.UID, this.params);
        this.logger.debug((Object)("TestGetSiteTitles StringAsTitleId: SiteTitleIds -" + this.response.get("SiteTitleIDs") + " Response Message -" + this.response.toString()));
        Assert.assertNull((Object)this.response.get("SiteTitleIDs"));
        Assert.assertNotNull((Object)this.response.get("error-message"));
    }
}

