/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.adaptor.messageidentifier;

import com.tandbergtv.workflow.adaptor.AdaptorRuntimeException;
import com.tandbergtv.workflow.adaptor.messageidentifier.IMessageIdentifier;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.MessageUIDImpl;
import com.tandbergtv.workflow.message.util.WPCLValidationException;
import com.tandbergtv.workflow.message.util.WPCLValidator;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WPCLMessageIdentifier
implements IMessageIdentifier {
    private static Logger logger = Logger.getLogger(WPCLMessageIdentifier.class);
    private static final ThreadLocal<DocumentBuilder> b = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                return dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new Error();
            }
        }
    };

    @Override
    public IMessageUID identify(IMessage message) {
        IMessageUID uid = null;
        try {
            logger.debug((Object)("Attempting to identify message: " + message.getPayload()));
            String payload = message.getPayload().getContent();
            DocumentBuilder db = b.get();
            db.reset();
            Document doc = db.parse(new InputSource(new StringReader(payload)));
            WPCLValidator.newInstance().validate(doc);
            uid = this.getUIDFromWPCL(doc);
        }
        catch (WPCLValidationException e) {
            throw new AdaptorRuntimeException("Message is not in WPCL format", e);
        }
        catch (Exception e) {
            throw new AdaptorRuntimeException(e);
        }
        return uid;
    }

    private IMessageUID getUIDFromWPCL(Document doc) throws XPathExpressionException {
        NodeList nodes = doc.getElementsByTagName("WFSMessage");
        Element e = (Element)nodes.item(0);
        String uid = e.getAttribute("UID");
        logger.debug((Object)("Message identified having uid:" + uid));
        return new MessageUIDImpl(uid);
    }
}

