/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import com.tandbergtv.workflow.driver.template.watch.AbstractFileListener;
import com.tandbergtv.workflow.driver.template.watch.FileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.par.ProcessArchive;

public class PackagedTemplateFileListener
extends AbstractFileListener {
    @Override
    protected WorkflowTemplate read(File file) {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            ProcessArchive par = new ProcessArchive(zipInputStream);
            byte[] bytes = par.getEntry("processdefinition.xml");
            if (bytes == null) {
                throw new JpdlException("No processdefinition.xml inside process archive " + file.getAbsolutePath());
            }
            WorkflowTemplate workflowTemplate = new FileReader(bytes).read();
            return workflowTemplate;
        }
        catch (IOException e) {
            throw new TemplateReaderException("Failed to read template " + file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException e) {
                    throw new TemplateReaderException("Failed to read template " + file.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }
}

