/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.common.util;

import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class ExpressSearchUtil {
    private static ExpressSearchUtil instance = new ExpressSearchUtil();
    private static final Logger logger = Logger.getLogger(ExpressSearchUtil.class);

    private ExpressSearchUtil() {
    }

    public static ExpressSearchUtil getInstance() {
        return instance;
    }

    public List<WFSearchResult> expressSearch(SearchCriteria searchCriteria, Session session) {
        List searchParameters = searchCriteria.getSearchList();
        ArrayList<SearchParameterBase> whereParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> whereVariableParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortVariableParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortList = null;
        ArrayList<SearchParameterBase> whereList = null;
        for (SearchParameterBase param : searchParameters) {
            if (param.isVarInstance()) {
                sortList = sortVariableParameters;
                whereList = whereVariableParameters;
            } else {
                sortList = sortParameters;
                whereList = whereParameters;
            }
            if (param instanceof SortParameter) {
                sortList.add(param);
                continue;
            }
            if (param.getPartialWhereClause() == null) continue;
            whereList.add(param);
        }
        ArrayList<WFSearchResult> processes = new ArrayList<WFSearchResult>();
        HashMap<Long, WFSearchResult> parentPidMap = new HashMap<Long, WFSearchResult>();
        String queryString = this.buildExpressQuery(searchCriteria, whereParameters, sortParameters, whereVariableParameters, sortVariableParameters, false, null);
        logger.debug((Object)("Executing search query:" + queryString));
        if (queryString != null) {
            this.fillResults(session, queryString, processes, parentPidMap);
        }
        logger.debug((Object)("Search Result:" + processes.size() + " Processes"));
        HashMap<Long, WFSearchResult> allPidMap = new HashMap<Long, WFSearchResult>();
        allPidMap.putAll(parentPidMap);
        int ORA_01795_LIMIT = 1000;
        int pidCount = 0;
        StringBuilder pids = new StringBuilder();
        Iterator pPidItr = parentPidMap.keySet().iterator();
        while (pPidItr.hasNext()) {
            if (pids.length() > 0) {
                pids.append(", ");
            }
            pids.append(pPidItr.next());
            if (++pidCount < 1000) continue;
            queryString = this.buildExpressQuery(searchCriteria, whereParameters, sortParameters, whereVariableParameters, sortVariableParameters, false, pids.toString());
            logger.debug((Object)("Executing search query for branches:" + queryString));
            if (queryString != null) {
                this.fillResults(session, queryString, processes, allPidMap);
            }
            logger.debug((Object)("Search Result:" + processes.size() + " Processes (including branches)"));
            pids.delete(0, pids.length());
            pidCount = 0;
        }
        if (pids.length() > 0) {
            queryString = this.buildExpressQuery(searchCriteria, whereParameters, sortParameters, whereVariableParameters, sortVariableParameters, false, pids.toString());
            logger.debug((Object)("Executing search query for branches:" + queryString));
            if (queryString != null) {
                this.fillResults(session, queryString, processes, allPidMap);
            }
            logger.debug((Object)("Search Result:" + processes.size() + " Processes (including branches)"));
        }
        pidCount = 0;
        pids = new StringBuilder();
        Iterator itr = allPidMap.keySet().iterator();
        while (itr.hasNext()) {
            if (pids.length() > 0) {
                pids.append(", ");
            }
            pids.append(itr.next());
            if (++pidCount < 1000) continue;
            this.fillVariables(pids.toString(), session, allPidMap);
            pids.delete(0, pids.length());
            pidCount = 0;
        }
        if (pids.length() > 0) {
            this.fillVariables(pids.toString(), session, allPidMap);
        }
        return processes;
    }

    private String buildExpressQuery(SearchCriteria searchCriteria, List<SearchParameterBase> whereParameters, List<SearchParameterBase> sortParameters, List<SearchParameterBase> whereVariableParameters, List<SearchParameterBase> sortVariableParameters, boolean forCount, String parentIds) {
        StringBuilder query = new StringBuilder();
        boolean sortByIdFound = false;
        boolean firstOrderBy = true;
        query.append("select");
        if (forCount) {
            query.append(" count(*) as RCOUNT");
        } else {
            query.append(" *");
        }
        query.append(" from (");
        query.append(" SELECT");
        if (forCount) {
            query.append(" DISTINCT p.id_ as P_ID ");
        } else {
            query.append(" LEVEL AS Lvl, rownum as RNUM, p.id_ as P_ID, ");
            query.append("p.roottoken_ as RootTokenId, t.id_ as T_ID, t.parent_ as ParentT_Id, t.operationalstatus AS OperationalStatus, t.administrativestatus as AdministrativeStat, p.start_ as StartTime, p.end_ as EndTime,");
            query.append(" d.name_ || '- v' || d.version_ as TemplateName, n.name_ as CurrentTask, l.ProtKey as ProtectionKey");
        }
        query.append(" FROM JBPM_TOKEN T, JBPM_PROCESSINSTANCE P, jbpm_processdefinition D, jbpm_node N");
        query.append(", (SELECT LISTAGG(al.name, ',') WITHIN GROUP (ORDER BY ll.processdefinitionid) as ProtKey, ll.processdefinitionid");
        query.append(" FROM TTV_PROCDEFACCESSLEVEL LL, TTV_ACCESSLEVEL AL");
        query.append(" WHERE LL.accesslevelid = AL.accesslevelid");
        for (SearchParameterBase param : whereParameters) {
            if (!"AccessLevel".equalsIgnoreCase(param.getFieldName())) continue;
            query.append(" AND ll.accesslevelid ").append(param.getPredicate());
        }
        query.append(" GROUP BY ll.processdefinitionid) L");
        int i = 0;
        while (i < whereVariableParameters.size()) {
            query.append(", JBPM_VARIABLEINSTANCE V").append(i);
            ++i;
        }
        if (!forCount && sortVariableParameters.size() > 0) {
            query.append(", JBPM_VARIABLEINSTANCE V_s");
        }
        query.append(" WHERE t.processInstance_ = p.id_");
        query.append(" AND d.id_ = p.processdefinition_ AND t.node_ = n.id_");
        query.append(" AND d.id_ = l.processdefinitionid");
        i = 0;
        while (i < whereVariableParameters.size()) {
            SearchParameterBase param = whereVariableParameters.get(i);
            query.append(" AND v").append(i).append(".processinstance_ (+)= p.id_ AND ");
            if (param.getClass().getName().equalsIgnoreCase("com.tandbergtv.watchpoint.pmm.title.activity.TitleKeysParameter") && param.getFieldName().equalsIgnoreCase("titleID")) {
                query.append(" (v").append(i).append(".name_ (+)= 'titleId' AND ");
                String partWC = param.getPartialWhereClause();
                if (partWC.indexOf(".stringVal is not null") > 0) {
                    query.append(" v").append(i).append(".STRINGVALUE_ IS NOT NULL ");
                } else {
                    partWC = partWC.substring(partWC.indexOf(".stringVal in (") + 15);
                    partWC = partWC.substring(0, partWC.indexOf(41));
                    query.append(" v").append(i).append(".STRINGVALUE_ ");
                    if (partWC.indexOf(44) > 0) {
                        query.append("IN (").append(partWC).append(")");
                    } else {
                        query.append("= ").append(partWC);
                    }
                }
                query.append(")");
            } else {
                query.append(" (v").append(i).append(".name_ (+)= '").append(param.getFieldName()).append("' AND ");
                switch (param.getFieldType()) {
                    case STRING: {
                        query.append(" v").append(i).append(".STRINGVALUE_ ").append(param.getPredicate());
                        break;
                    }
                    case NUMERIC: {
                        query.append(" v").append(i).append(".LONGVALUE_ ").append(param.getPredicate());
                        break;
                    }
                    case DATE: {
                        query.append(" v").append(i).append(".DATEVALUE_ ").append(param.getPredicate());
                        break;
                    }
                    default: {
                        query.append(" v").append(i).append(".STRINGVALUE_ ").append(param.getPredicate());
                    }
                }
                query.append(")");
            }
            ++i;
        }
        if (!forCount && sortVariableParameters.size() > 0) {
            for (SearchParameterBase param : sortVariableParameters) {
                query.append(" AND v_s.processinstance_ (+)= p.id_ AND (v_s.name_ (+)= '").append(param.getFieldName()).append("')");
            }
        }
        if (parentIds == null) {
            query.append(" AND LEVEL = 1");
        } else {
            query.append(" AND LEVEL > 1 AND p.id_ IN (").append(parentIds).append(")");
        }
        query.append(" START WITH t.parent_ IS NULL");
        query.append(" AND d.processdefinitiontypeid = 2 AND p.isActive = 1");
        for (SearchParameterBase param : whereParameters) {
            if ("id".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.id_ ").append(param.getPredicate());
                continue;
            }
            if ("tokenId".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND t.id_ ").append(param.getPredicate());
                continue;
            }
            if ("start".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.start_ ").append(param.getPredicate());
                continue;
            }
            if ("end".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.end_ ").append(param.getPredicate());
                continue;
            }
            if ("processDefinition.id".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND d.id_ ").append(param.getPredicate());
                continue;
            }
            if ("priority".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.processpriorityid ").append(param.getPredicate());
                continue;
            }
            if ("status".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.operationalprocessstatusid ");
                query.append(param.getPartialWhereClause().substring(param.getPartialWhereClause().indexOf("IN")));
                continue;
            }
            if ("requestedStatus".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.administrativeprocessstatusid ");
                query.append(param.getPartialWhereClause().substring(param.getPartialWhereClause().indexOf("IN")));
                continue;
            }
            if ("rootToken.node.name".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND n.name_ ").append(param.getPredicate());
                continue;
            }
            logger.error((Object)("Missed out condition - " + param.getFieldName() + ", " + param.getPartialWhereClause()));
            System.out.println("Missed out condition - " + param.getFieldName() + ", " + param.getPartialWhereClause());
        }
        query.append(" CONNECT BY t.parent_ = PRIOR t.id_ ");
        if (!forCount) {
            String orderByClause;
            query.append(" ORDER SIBLINGS by ");
            for (SearchParameterBase param : sortVariableParameters) {
                orderByClause = "";
                switch (param.getFieldType()) {
                    case STRING: {
                        orderByClause = "v_s.STRINGVALUE_";
                        break;
                    }
                    case NUMERIC: {
                        orderByClause = "v_s.LONGVALUE_";
                        break;
                    }
                    case DATE: {
                        orderByClause = "v_s.DATEVALUE_";
                        break;
                    }
                    default: {
                        orderByClause = "v_s.STRINGVALUE_";
                    }
                }
                if (orderByClause.length() <= 0) continue;
                query.append(firstOrderBy ? "" : ", ").append(orderByClause).append(SortingOrder.DESCENDING.equals((Object)param.getSortingOrder()) ? " DESC NULLS FIRST " : " ASC NULLS LAST ");
                firstOrderBy = false;
            }
            for (SearchParameterBase param : sortParameters) {
                orderByClause = "";
                if ("id".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.id_";
                    sortByIdFound = true;
                } else if ("start".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.start_";
                } else if ("end".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.end_";
                } else if ("workOrderTemplate".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "d.name_";
                } else if ("processDefinition.id".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "d.id_";
                } else if ("priority".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.processpriorityid";
                } else if ("status".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.operationalprocessstatusid";
                } else if ("requestedStatus".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.administrativeprocessstatusid";
                } else if ("rootToken.node.name".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "n.name_";
                } else if ("processDefinition.name".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "d.name_";
                } else {
                    logger.error((Object)("Missed out condition - " + param.getFieldName() + ", " + param.getSortingColumn()));
                    System.out.println("Missed out condition - " + param.getFieldName() + ", " + param.getSortingColumn());
                    continue;
                }
                if (orderByClause.length() <= 0) continue;
                query.append(firstOrderBy ? "" : ", ").append(orderByClause).append(SortingOrder.DESCENDING.equals((Object)param.getSortingOrder()) ? " DESC NULLS LAST " : " ASC NULLS FIRST ");
                firstOrderBy = false;
            }
            if (!sortByIdFound) {
                query.append(firstOrderBy ? "" : ",").append(" p.id_ DESC");
            }
        }
        query.append(") BB ");
        if (!forCount && searchCriteria.getRecordsCount() > 0 && parentIds == null) {
            query.append("WHERE RNUM BETWEEN ").append(searchCriteria.getStartingRecordNumber() + 1).append(" AND ").append(searchCriteria.getStartingRecordNumber() + searchCriteria.getRecordsCount());
        }
        return query.toString();
    }

    private void fillResults(Session session, String queryString, List<WFSearchResult> processes, Map<Long, WFSearchResult> pidMap) {
        SQLQuery query = session.createSQLQuery(queryString).addScalar("Lvl", (Type)Hibernate.INTEGER).addScalar("RNUM", (Type)Hibernate.LONG).addScalar("P_ID", (Type)Hibernate.LONG).addScalar("RootTokenId", (Type)Hibernate.LONG).addScalar("T_ID", (Type)Hibernate.LONG).addScalar("ParentT_Id", (Type)Hibernate.LONG).addScalar("OperationalStatus", (Type)Hibernate.LONG).addScalar("AdministrativeStat", (Type)Hibernate.LONG).addScalar("StartTime", (Type)Hibernate.TIMESTAMP).addScalar("EndTime", (Type)Hibernate.TIMESTAMP).addScalar("TemplateName", (Type)Hibernate.STRING).addScalar("CurrentTask", (Type)Hibernate.STRING).addScalar("ProtectionKey", (Type)Hibernate.STRING);
        query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        List results = query.list();
        for (Object object : results) {
            Map row = (Map)object;
            WFSearchResult wfsr = null;
            int hierarchyLevel = (Integer)row.get("Lvl");
            long procId = (Long)row.get("P_ID");
            wfsr = pidMap.get(procId);
            if (wfsr == null && hierarchyLevel == 1) {
                wfsr = new WFSearchResult();
                wfsr.setProcessDefinitionName((String)row.get("TemplateName"));
                wfsr.setProcessId(procId);
                wfsr.setProtectionKeys((String)row.get("ProtectionKey"));
                wfsr.setRootTokenId(((Long)row.get("RootTokenId")).longValue());
                WFToken token = new WFToken();
                token.setAdministrativeStatus(((Long)row.get("AdministrativeStat")).longValue());
                token.setEndTime((Date)row.get("EndTime"));
                token.setNodeName((String)row.get("CurrentTask"));
                token.setOperationalStatus(((Long)row.get("OperationalStatus")).longValue());
                token.setStartTime((Date)row.get("StartTime"));
                token.setTokenId(((Long)row.get("T_ID")).longValue());
                token.setProcessId(procId);
                wfsr.setToken(token);
                if (row.get("ParentT_Id") != null) {
                    logger.error((Object)"Unexpected error - Parent Token Id is NULL for top level record!");
                }
                processes.add(wfsr);
                pidMap.put(procId, wfsr);
                continue;
            }
            if (hierarchyLevel > 1) {
                WFToken rootToken = wfsr.getToken();
                long parentTokenId = (Long)row.get("ParentT_Id");
                WFToken parentToken = rootToken.getChildWithId(parentTokenId);
                WFToken token = new WFToken();
                token.setAdministrativeStatus(((Long)row.get("AdministrativeStat")).longValue());
                token.setEndTime((Date)row.get("EndTime"));
                token.setNodeName((String)row.get("CurrentTask"));
                token.setOperationalStatus(((Long)row.get("OperationalStatus")).longValue());
                token.setStartTime((Date)row.get("StartTime"));
                token.setTokenId(((Long)row.get("T_ID")).longValue());
                token.setProcessId(procId);
                parentToken.addChild(token);
                continue;
            }
            if (queryString.contains(", JBPM_VARIABLEINSTANCE V")) continue;
            logger.error((Object)("Results did not come from DB in the order that code expected. Query : " + queryString));
            System.out.println("Results did not come from DB in the order that code expected. Query : " + queryString);
        }
    }

    private void fillVariables(String pids, Session session, Map<Long, WFSearchResult> pidMap) {
        if (pids.length() < 1) {
            return;
        }
        String queryString2 = this.buildVariablesQuery(pids);
        SQLQuery query2 = session.createSQLQuery(queryString2).addScalar("PROCESSINSTANCE_", (Type)Hibernate.LONG).addScalar("ID_", (Type)Hibernate.LONG).addScalar("CLASS_", (Type)Hibernate.CHARACTER).addScalar("NAME_", (Type)Hibernate.STRING).addScalar("CONVERTER_", (Type)Hibernate.STRING).addScalar("TOKEN_", (Type)Hibernate.LONG).addScalar("STRINGVALUE_", (Type)Hibernate.STRING).addScalar("LONGVALUE_", (Type)Hibernate.LONG).addScalar("DOUBLEVALUE_", (Type)Hibernate.DOUBLE);
        query2.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        List varResults = query2.list();
        for (Object object : varResults) {
            Map row = (Map)object;
            String varName = (String)row.get("NAME_");
            String value = null;
            WFVariable var = new WFVariable();
            var.setName(varName);
            switch (((Character)row.get("CLASS_")).charValue()) {
                case 'S': {
                    value = (String)row.get("STRINGVALUE_");
                    break;
                }
                case 'L': {
                    if (row.get("LONGVALUE_") == null) {
                        if (row.get("DOUBLEVALUE_") == null) {
                            value = null;
                            break;
                        }
                        value = Double.toString((Double)row.get("DOUBLEVALUE_"));
                        break;
                    }
                    value = Long.toString((Long)row.get("LONGVALUE_"));
                    break;
                }
                case 'D': {
                    value = ((Date)row.get("DATEVALUE_")).toString();
                    break;
                }
            }
            var.addValue(value);
            long pid = (Long)row.get("PROCESSINSTANCE_");
            WFSearchResult sr = pidMap.get(pid);
            sr.addVariable(var);
        }
        logger.debug((Object)"Processes filled with variables");
    }

    private String buildVariablesQuery(String commaSeparatedPIDList) {
        StringBuilder query = new StringBuilder();
        query.append("select * from jbpm_variableinstance v where v.processinstance_ in (").append(commaSeparatedPIDList).append(") ");
        return query.toString();
    }

    public int expressCount(SearchCriteria searchCriteria, Session session) {
        int count = 0;
        List searchParameters = searchCriteria.getSearchList();
        ArrayList<SearchParameterBase> whereParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> whereVariableParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortVariableParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortList = null;
        ArrayList<SearchParameterBase> whereList = null;
        for (SearchParameterBase param : searchParameters) {
            if (param.isVarInstance()) {
                sortList = sortVariableParameters;
                whereList = whereVariableParameters;
            } else {
                sortList = sortParameters;
                whereList = whereParameters;
            }
            if (param instanceof SortParameter) {
                sortList.add(param);
                continue;
            }
            if (param.getPartialWhereClause() == null) continue;
            whereList.add(param);
        }
        String queryString = this.buildExpressQuery(searchCriteria, whereParameters, sortParameters, whereVariableParameters, sortVariableParameters, true, null);
        logger.debug((Object)("Executing search query:" + queryString));
        if (queryString != null) {
            SQLQuery query = session.createSQLQuery(queryString).addScalar("RCOUNT", (Type)Hibernate.INTEGER);
            query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
            List results = query.list();
            if (results != null && results.get(0) != null) {
                Map row = (Map)results.get(0);
                count = (Integer)row.get("RCOUNT");
            }
        }
        logger.debug((Object)("Found " + count + " Processes"));
        return count;
    }
}

