/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.graph.Loop;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.logging.log.ProcessLog;

public abstract class AbstractTaskNode
extends TaskNode
implements ResourceGroupAware {
    private Long resourceGroupID = DEFAULT_RESOURCE_GROUP_ID;
    private static final Long DEFAULT_RESOURCE_GROUP_ID = -1L;
    private static final Logger logger = Logger.getLogger(AbstractTaskNode.class);
    private static final long serialVersionUID = 36501193930537732L;

    public AbstractTaskNode() {
    }

    public AbstractTaskNode(String name) {
        super(name);
    }

    @Override
    public Long getResourceGroupID() {
        if (this.resourceGroupID.equals(DEFAULT_RESOURCE_GROUP_ID)) {
            return null;
        }
        return this.resourceGroupID;
    }

    @Override
    public void setResourceGroupID(Long resourceGroupID) {
        this.resourceGroupID = resourceGroupID == null ? DEFAULT_RESOURCE_GROUP_ID : resourceGroupID;
    }

    public Transition getDefaultLeavingTransition() {
        if (this.leavingTransitions == null || this.leavingTransitions.isEmpty()) {
            AbstractTaskNode parent = this;
            while (parent.getSuperState() instanceof SuperState) {
                if (!((parent = parent.getSuperState()) instanceof Loop)) continue;
                return this.createLeavingTransition();
            }
        }
        return super.getDefaultLeavingTransition();
    }

    public void enter(ExecutionContext executionContext) {
        CustomToken token = (CustomToken)executionContext.getToken();
        token.setNode((Node)this);
        if (token.getStatus() != ProcessStatus.RUNNING) {
            throw new InvalidProcessStateException(token.toString());
        }
        logger.info((Object)("[Process] " + token + " (" + this.name + ")"));
        this.fireEvent("node-enter", executionContext);
        token.acquire();
        token.setNodeEnter(new Date());
        executionContext.setTransition(null);
        executionContext.setTransitionSource(null);
        this.execute(executionContext);
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        CustomToken token = (CustomToken)executionContext.getToken();
        if (token.getStatus() != ProcessStatus.BUSY) {
            throw new InvalidProcessStateException(token.toString());
        }
        logger.info((Object)("[Process] " + token + " (" + this.name + ")"));
        token.setNode((Node)this);
        executionContext.setTransition(transition);
        this.fireEvent("node-leave", executionContext);
        token.addLog((ProcessLog)new NodeLog((Node)this, token.getNodeEnter(), new Date()));
        executionContext.setTransitionSource((Node)this);
        token.release();
        transition.take(executionContext);
    }

    public void read(Element nodeElement, JpdlXmlReader jpdlXmlReader) {
        this.action = jpdlXmlReader.readSingleAction(nodeElement);
        super.read(nodeElement, jpdlXmlReader);
    }

    protected Transition createLeavingTransition() {
        Transition transition = new Transition(){
            private static final long serialVersionUID = 1L;

            public void take(ExecutionContext context) {
                this.fireEvent("transition", context);
                SuperState parent = AbstractTaskNode.this.getSuperState();
                if (parent instanceof NodeGroup) {
                    parent.leave(context);
                }
            }
        };
        transition.setFrom((Node)this);
        transition.setProcessDefinition(this.processDefinition);
        if (this.getResourceGroupID() != null || this.getSuperState() instanceof NodeGroup) {
            this.addEvent(transition, "resource-release");
        }
        return transition;
    }

    protected void addEvent(Transition transition, String action) {
        Event event = new Event((GraphElement)transition, "transition");
        Action a = transition.getProcessDefinition().getAction(action);
        event.addAction(new Action(a.getActionDelegation()));
        transition.addEvent(event);
    }
}

