/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.resource;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.ResourceGroupAware;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.resourcemanager.event.AcquireResourceEvent;
import org.apache.log4j.Logger;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;

public class RequestResource
implements ActionHandler {
    private static final Logger logger = Logger.getLogger(RequestResource.class);
    public static final String RESOURCE_ALLOCATION_VAR = "_resource_host";
    private static final long serialVersionUID = -991843493973408120L;

    public void execute(ExecutionContext ec) throws Exception {
        if (!this.needsResource(ec)) {
            return;
        }
        CustomToken token = (CustomToken)ec.getToken();
        token.queue();
        Node node = token.getCurrentNode();
        if (!(node instanceof ResourceGroupAware)) {
            throw new ActionException(token + " cannot request resource for this node: " + node.getName());
        }
        logger.info((Object)(token + " (" + node.getName() + ") trying to acquire resource"));
        Long resourceGroupId = ((ResourceGroupAware)node).getResourceGroupID();
        String allocationKey = this.getResourceAllocationKey(ec);
        DefaultMediator.getInstance().send((WorkflowEvent)new AcquireResourceEvent((Object)this, token, resourceGroupId, allocationKey));
    }

    private String getResourceAllocationKey(ExecutionContext ec) {
        ContextInstance ci = ec.getContextInstance();
        Object value = ci.getVariable("_resource_host_" + ec.getToken().getId());
        if (value == null) {
            value = ci.getVariable(RESOURCE_ALLOCATION_VAR);
        }
        if (value == null) {
            value = ci.getVariable("_current_resource_" + ec.getToken().getId());
        }
        return value != null ? value.toString() : null;
    }

    private boolean needsResource(ExecutionContext context) {
        Node node = context.getNode();
        return !Boolean.getBoolean("com.tandbergtv.workflow.resourcemanager.consumertrace.disable") || node instanceof ManualTaskNode;
    }
}

