/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.core.Recorder;
import com.tandbergtv.workflow.monitor.internal.FileRecorderProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FileSystemRecorder
extends Recorder {
    private File root;
    private static final long EXPIRE_PERIOD = TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS);
    private static final Logger logger = Logger.getLogger(FileSystemRecorder.class);

    public FileSystemRecorder(ISchedulerService<Void> pool, String name, File root) {
        super(pool, name);
        this.root = root;
    }

    public File getRoot() {
        return this.root;
    }

    @Override
    public void record() {
        for (IObserver observer : this.observers) {
            List<Metric> metrics = observer.getMetrics();
            for (Metric metric : metrics) {
                File dir = FileRecorderProperties.directoryFor(this.root, metric);
                File file = FileRecorderProperties.getFile(dir, metric);
                logger.debug((Object)("File " + file.getAbsolutePath()));
                this.update(file, metric);
            }
            this.cleanup(metrics);
        }
    }

    private void update(File file, Metric metric) {
        block12: {
            Writer out = null;
            try {
                try {
                    String time = String.valueOf(metric.getTime());
                    String value = metric.getValue().toString();
                    FileOutputStream os = new FileOutputStream(file, true);
                    out = new OutputStreamWriter((OutputStream)os, "UTF-8");
                    out.append(metric.getName()).append('\t').append(time).append('\t').append(value);
                    out.append(System.getProperty("line.separator"));
                }
                catch (IOException e) {
                    logger.warn((Object)("Cannot update " + file), (Throwable)e);
                    if (out == null) break block12;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void cleanup(List<Metric> metrics) {
        if (metrics.isEmpty()) {
            return;
        }
        Metric metric = metrics.get(0);
        File dir = FileRecorderProperties.directoryFor(this.root, metric);
        this.cleanup(dir, this.getDomains(metrics));
    }

    private List<String> getDomains(List<Metric> metrics) {
        ArrayList<String> list = new ArrayList<String>();
        for (Metric metric : metrics) {
            list.add(metric.getDomain());
        }
        return list;
    }

    private void cleanup(File dir, List<String> prefixes) {
        File[] list;
        File[] fileArray = list = dir.listFiles();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            for (String prefix : prefixes) {
                long delta;
                if (!file.getName().startsWith(prefix) || (delta = System.currentTimeMillis() - file.lastModified()) <= EXPIRE_PERIOD) continue;
                logger.debug((Object)("Deleting file " + file.getAbsolutePath()));
                file.delete();
            }
            ++n2;
        }
    }
}

