/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.log.entities.ProcessQueuedPerResourceLog;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.entities.WorkflowMessageLog;
import com.tandbergtv.workflow.log.file.JSONConverter;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class EventDeserializer {
    public static NodeLog deSerializeNodeLog(Token token, File file) {
        Map<String, Object> deserialized = JSONConverter.read(file);
        if (deserialized.isEmpty()) {
            return null;
        }
        Long id = (Long)deserialized.get("id");
        Long startTime = (Long)deserialized.get("startTime");
        Long endTime = (Long)deserialized.get("endTime");
        Integer nodeId = (Integer)deserialized.get("nodeId");
        Node node = EventDeserializer.findNodeById(nodeId.intValue(), (WorkflowTemplate)token.getProcessInstance().getProcessDefinition());
        if (node == null) {
            return null;
        }
        NodeLog result = new NodeLog(node, new Date(startTime), new Date(endTime));
        EventDeserializer.setProcessLogId((ProcessLog)result, id);
        result.setToken(token);
        return result;
    }

    public static WorkflowMessageLog deSerializeMessageLog(File file) {
        Map<String, Object> deserialized = JSONConverter.read(file);
        if (deserialized.isEmpty()) {
            return null;
        }
        WorkflowMessageLog result = new WorkflowMessageLog();
        result.setMessageUID((String)deserialized.get("messageUID"));
        result.setMessageType((String)deserialized.get("messageType"));
        result.setMessageName((String)deserialized.get("messageName"));
        result.setMessage((String)deserialized.get("message"));
        result.setIncoming((Boolean)deserialized.get("incoming"));
        result.setTimestamp(new Date((Long)deserialized.get("timestamp")));
        result.setResource(deserialized.get("resourceId") != null && !"".equals(deserialized.get("resourceId")) ? new Resource(new Long(deserialized.get("resourceId").toString()).longValue()) : null);
        result.setId((Long)deserialized.get("id"));
        return result;
    }

    public static ProcessStatusPerResourceLog deSerializeResourceLog(File file) {
        Map<String, Object> fields = JSONConverter.read(file);
        if (fields.isEmpty()) {
            return null;
        }
        ProcessStatusPerResourceLog log = null;
        log = fields.get("queued") != null && Boolean.TRUE.equals(fields.get("queued")) ? new ProcessQueuedPerResourceLog() : new ProcessStatusPerResourceLog();
        if (EventDeserializer.hasField(fields, "tokenId")) {
            log.setTokenId(EventDeserializer.parseLong(fields, "tokenId"));
        }
        log.setNodeId(EventDeserializer.parseLong(fields, "nodeId"));
        log.setResourceGroupId(EventDeserializer.parseLong(fields, "resourceGroupId"));
        log.setResourceId(EventDeserializer.parseLong(fields, "resourceId"));
        log.setStartTime(EventDeserializer.parseDate(fields, "startTime"));
        log.setEndTime(EventDeserializer.parseDate(fields, "endTime"));
        log.setOperationalStatus(ProcessStatus.valueOf((String)((String)fields.get("operationalStatus"))));
        log.setAdminStatus(ProcessStatus.valueOf((String)((String)fields.get("adminStatus"))));
        return log;
    }

    private static boolean hasField(Map<String, Object> fields, String field) {
        return fields.containsKey(field);
    }

    private static Date parseDate(Map<String, Object> fields, String field) {
        return new Date(EventDeserializer.parseLong(fields, field));
    }

    private static Long parseLong(Map<String, Object> fields, String field) {
        return Long.valueOf(fields.get(field).toString());
    }

    private static void setProcessLogId(ProcessLog processLog, Long value) {
        try {
            Field field = ProcessLog.class.getDeclaredField("id");
            field.setAccessible(true);
            field.set(processLog, value);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Node findNodeById(final long nodeId, WorkflowTemplate processDefinition) {
        final ArrayList result = new ArrayList();
        processDefinition.breadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                if (nodeId == node.getId()) {
                    result.add(node);
                }
            }
        });
        if (result.size() > 0) {
            return (Node)result.get(0);
        }
        return null;
    }

    public static boolean skipDeserialize(Token token, File file) {
        Map<String, Object> deserialized = JSONConverter.read(file);
        if (deserialized.isEmpty()) {
            return true;
        }
        Integer nodeId = (Integer)deserialized.get("nodeId");
        return EventDeserializer.findNodeById(nodeId.intValue(), (WorkflowTemplate)token.getProcessInstance().getProcessDefinition()) == null;
    }
}

