/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;

public class TimestampFile {
    public static long getMostRecentTimestamp(File dir, String filePrefix) {
        File[] files = TimestampFile.getSortedFiles(dir, filePrefix);
        if (files.length > 0) {
            File lastFile = files[files.length - 1];
            return Long.parseLong(lastFile.getName().substring(filePrefix.length()));
        }
        return 0L;
    }

    public static void setMostRecentTimestamp(File dir, String filePrefix, long time) {
        File file = new File(dir, filePrefix + time);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        TimestampFile.deletePreviousFiles(dir, filePrefix);
    }

    private static void deletePreviousFiles(File dir, String filePrefix) {
        File[] files = TimestampFile.getSortedFiles(dir, filePrefix);
        for (int i = 0; i < files.length - 1; ++i) {
            files[i].delete();
        }
    }

    private static File[] getSortedFiles(File dir, final String filePrefix) {
        if (dir == null || !dir.exists()) {
            throw new IllegalArgumentException("Invalid directory " + dir);
        }
        Object[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(filePrefix);
            }
        });
        if (files == null) {
            return new File[0];
        }
        if (files.length > 0) {
            Arrays.sort(files);
        }
        return files;
    }
}

