/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.log.EventDeserializer;
import com.tandbergtv.workflow.log.LogSyncState;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.LogFileNames;
import com.tandbergtv.workflow.log.hibernate.ProcessLogHDAO;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jbpm.logging.log.ProcessLog;

public class LogSyncCallable
implements Callable<Long> {
    private SessionFactory factory;
    private Set<Long> set;
    private String dir;
    private int threadNum;
    private long windowStart;
    private long windowEnd;
    private static final Logger logger = Logger.getLogger(LogSyncCallable.class);

    public LogSyncCallable(SessionFactory factory, Set<Long> set, String dir, int threadNum, long windowStart, long windowEnd) {
        if (set == null) {
            throw new IllegalArgumentException();
        }
        this.factory = factory;
        this.set = set;
        this.dir = dir;
        this.threadNum = threadNum;
        this.windowStart = windowStart;
        this.windowEnd = windowEnd;
    }

    @Override
    public Long call() throws Exception {
        Long t = System.currentTimeMillis();
        for (Long id : this.set) {
            this.write(id, this.windowStart, this.windowEnd);
        }
        Long delta = (System.currentTimeMillis() - t) / 1000L;
        logger.debug((Object)("Elapsed time " + delta + "s"));
        return Collections.max(this.set);
    }

    private void write(long id, long windowStart, long windowEnd) {
        logger.debug((Object)("ID " + id));
        LogSyncState.setNextId(this.dir, this.threadNum, id);
        try {
            Collection<ProcessLog> list = this.getLogs(id, windowStart, windowEnd);
            ProcessLogHDAO dao = new ProcessLogHDAO((Session)this.factory.openSession());
            dao.create(list);
        }
        catch (Throwable e) {
            logger.warn((Object)("Failed to sync logs for [" + id + "]"), e);
        }
    }

    private Collection<ProcessLog> getLogs(long id, final long windowStart, final long windowEnd) {
        String directoryPath = Directories.pathFor(this.dir, id);
        File dir = new File(directoryPath);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("-resourceLog") && LogFileNames.extractFileTimestamp(name) >= windowStart && LogFileNames.extractFileTimestamp(name) < windowEnd;
            }
        });
        ArrayList<ProcessLog> result = new ArrayList<ProcessLog>();
        if (files == null) {
            return result;
        }
        for (File file : files) {
            ProcessStatusPerResourceLog log = EventDeserializer.deSerializeResourceLog(file);
            if (log == null || log.getToken() == null) continue;
            result.add(log);
        }
        return result;
    }
}

