/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.log.Finder;
import com.tandbergtv.workflow.log.LogSyncState;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.TimestampFile;
import com.tandbergtv.workflow.log.file.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class LogZipService
implements Service {
    private static final String zippedTimeFile = "zipServiceTime_";
    private static final Logger logger = Logger.getLogger(LogZipService.class);
    private Finder finder;
    private ISchedulerService<Void> scheduler;
    private String dir;
    private long period;

    public LogZipService(SessionFactory factory, String dir, long period) {
        this.finder = new Finder(factory);
        this.scheduler = new Scheduler("log-zip", 1, 1);
        this.dir = dir;
        this.period = period;
    }

    public void start() {
        this.scheduler.start();
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                LogZipService.this.compress();
            }
        }, 0L, this.period * 1000L);
    }

    public void stop() {
        this.scheduler.stop();
    }

    public String getServiceName() {
        return "log-zip";
    }

    private void compress() {
        long windowStart = TimestampFile.getMostRecentTimestamp(new File(this.dir), zippedTimeFile);
        if (windowStart == 0L) {
            logger.info((Object)"Initializing zip time because no existing state info (This should only happen once!)");
            this.setZipComplete(System.currentTimeMillis());
            return;
        }
        LogSyncState logSyncState = new LogSyncState(this.dir);
        long windowEnd = logSyncState.getLastSuccessfulRunTime();
        if (windowEnd == 0L || windowEnd <= windowStart) {
            return;
        }
        List<Long> list = this.finder.findCompletedOrCancelledBetween(new Date(windowStart), new Date(windowEnd));
        for (Long id : list) {
            File nextDir = new File(Directories.pathFor(this.dir, id));
            if (!nextDir.exists() || !nextDir.isDirectory()) continue;
            try {
                ZipUtil.compress(nextDir);
                for (File file : nextDir.listFiles()) {
                    if (file.getName().endsWith(".zip")) continue;
                    file.delete();
                }
            }
            catch (IOException e) {
                logger.error((Object)("Unable to compress " + nextDir + ".  " + e.getMessage()));
            }
        }
        this.setZipComplete(windowEnd);
    }

    private void setZipComplete(long time) {
        TimestampFile.setMostRecentTimestamp(new File(this.dir), zippedTimeFile, time);
    }
}

