/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jbpm.logging.log.ProcessLog;

public class LogReader {
    private String dir;

    public LogReader(String dir) {
        this.dir = dir;
    }

    public List<ProcessLog> getLogs(Class<? extends ProcessLog> type, long id) {
        try {
            List<ProcessLog> list = ZipUtil.read(this.zipFile(id));
            this.sort(list);
            Iterator<ProcessLog> i = list.iterator();
            while (i.hasNext()) {
                ProcessLog log = i.next();
                if (log.getClass().equals(type)) continue;
                i.remove();
            }
            return list;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private File zipFile(long id) {
        return new File(Directories.directoryFor(this.dir, id), id + ".zip");
    }

    private void sort(List<ProcessLog> list) {
        Collections.sort(list, new Comparator<ProcessLog>(){

            @Override
            public int compare(ProcessLog o1, ProcessLog o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
    }
}

