/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.log.Finder;
import com.tandbergtv.workflow.log.entities.ProcessStatusPerResourceLog;
import com.tandbergtv.workflow.log.file.Deserializer;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.FileNameMatcher;
import com.tandbergtv.workflow.log.file.LogFileNames;
import com.tandbergtv.workflow.log.file.TimestampFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class LogSyncState {
    private static final String windowFile = "window";
    private static final String lastSuccessFile = "last_";
    private static final String masterIdFile = "masterIds";
    private static final String threadIdFile = "thread_";
    private static final Logger logger = Logger.getLogger(LogSyncState.class);
    private File dir;

    public LogSyncState(String dirPath) {
        this.dir = new File(dirPath);
    }

    public boolean performInit() {
        if (this.getLastSuccessfulRunTime() == 0L) {
            this.setSyncComplete(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public boolean lastRunWasSuccessful() {
        long lastSuccess = this.getLastSuccessfulRunTime();
        long[] window = this.getWindow();
        return window == null || window[1] <= lastSuccess;
    }

    public long getLastSuccessfulRunTime() {
        return TimestampFile.getMostRecentTimestamp(this.dir, lastSuccessFile);
    }

    public void setSyncComplete(long time) {
        TimestampFile.setMostRecentTimestamp(this.dir, lastSuccessFile, time);
        Set<Long> pendingIds = this.getPendingIds(null, 0L, 0L);
        if (!pendingIds.isEmpty()) {
            logger.warn((Object)("Sync complete but pending " + pendingIds.size() + " work orders."));
        }
        File fWindow = new File(this.dir, windowFile);
        fWindow.delete();
        File fMaster = new File(this.dir, masterIdFile);
        fMaster.delete();
        this.deleteThreadFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getWindow() {
        File fWindow = new File(this.dir, windowFile);
        if (!fWindow.exists()) {
            return null;
        }
        BufferedReader br = null;
        long start = 0L;
        long end = 0L;
        try {
            br = new BufferedReader(new FileReader(fWindow));
            start = Long.parseLong(br.readLine());
            end = Long.parseLong(br.readLine());
        }
        catch (Exception e) {
            long[] lArray = null;
            return lArray;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {}
        }
        return new long[]{start, end};
    }

    public void setWindow(long start, long end) {
        File fWindow = new File(this.dir, windowFile);
        PrintWriter pw = null;
        try {
            fWindow.createNewFile();
            pw = new PrintWriter(new FileWriter(fWindow));
            pw.println(start);
            pw.println(end);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    public void setMasterIds(List<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        File file = new File(this.dir, masterIdFile);
        PrintWriter pw = null;
        try {
            file.createNewFile();
            pw = new PrintWriter(new FileWriter(file));
            for (Long next : ids) {
                pw.println(next);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    public static void setNextId(String dirPath, int threadNum, long id) {
        File file = new File(dirPath, threadIdFile + threadNum);
        PrintWriter pw = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            pw = new PrintWriter(new FileWriter(file, true));
            pw.println(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    public Set<Long> getPendingIds(Finder finder, long windowStart, long windowEnd) {
        HashSet<Long> pendingList = new HashSet<Long>();
        File fMaster = new File(this.dir, masterIdFile);
        if (fMaster.exists()) {
            pendingList.addAll(this.getIdsFromFile(fMaster));
            if (pendingList.size() > 0) {
                pendingList.removeAll(this.getCompletedList(finder, windowStart, windowEnd));
            }
        }
        return pendingList;
    }

    private List<Long> getCompletedList(Finder finder, long windowStart, long windowEnd) {
        File[] files;
        ArrayList<Long> ids = new ArrayList<Long>();
        for (File next : files = this.dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(LogSyncState.threadIdFile);
            }
        })) {
            int logCount;
            Long notSureIfCompleteId;
            Long incompleteTokenId;
            List<Long> threadIds = this.getIdsFromFile(next);
            if (finder != null && (incompleteTokenId = this.getFirstTokenId(notSureIfCompleteId = threadIds.get(threadIds.size() - 1), windowStart, windowEnd)) != null && (logCount = finder.getLogCountAfter(incompleteTokenId, new Date(windowStart))) == 0) {
                threadIds.remove(threadIds.size() - 1);
            }
            ids.addAll(threadIds);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getIdsFromFile(File file) {
        ArrayList<Long> ids = new ArrayList<Long>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            String next = br.readLine();
            while (next != null) {
                Long id = Long.parseLong(next);
                ids.add(id);
                next = br.readLine();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {}
        }
        return ids;
    }

    private void deleteThreadFiles() {
        File[] files;
        for (File file : files = this.dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(LogSyncState.threadIdFile);
            }
        })) {
            file.delete();
        }
    }

    private Long getFirstTokenId(long id, final long windowStart, final long windowEnd) {
        FileNameMatcher matcher = new FileNameMatcher(){

            @Override
            public boolean match(String name) {
                if (name.endsWith("-resourceLog")) {
                    Long timestamp = LogFileNames.extractFileTimestamp(name);
                    return timestamp >= windowStart && timestamp < windowEnd;
                }
                return false;
            }
        };
        File woDir = new File(Directories.pathFor(this.dir.getAbsolutePath(), id));
        if (!woDir.exists()) {
            return null;
        }
        File[] files = Directories.list(woDir, matcher);
        if (files.length == 0) {
            return null;
        }
        ProcessStatusPerResourceLog resLog = (ProcessStatusPerResourceLog)new Deserializer(files[0]).deserialize();
        return new Long(resLog.getToken().getId());
    }
}

