/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.log.SortColumnEnum;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

public class LogFileNames {
    private static final int ONE_BEFORE_SUFFIX = Integer.MAX_VALUE;
    private static final int TWO_BEFORE_SUFFIX = 0x7FFFFFFE;

    public static long getTokenId(String fileName) {
        return Long.valueOf(LogFileNames.getNthElementFromFileName(fileName, 0x7FFFFFFE));
    }

    public static long getNodeId(String fileName) {
        return Long.valueOf(LogFileNames.getNthElementFromFileName(fileName, Integer.MAX_VALUE));
    }

    public static long extractFileTimestamp(String fileName) {
        return Long.valueOf(LogFileNames.getNthElementFromFileName(fileName, 0));
    }

    public static String extractMessageUid(String fileName) {
        return LogFileNames.getNthElementFromFileName(fileName, 1);
    }

    public static String extractMessageName(String fileName) {
        return LogFileNames.getNthElementFromFileName(fileName, 2);
    }

    public static String extractMessageType(String fileName) {
        return LogFileNames.getNthElementFromFileName(fileName, 3);
    }

    public static String extractMessageIncoming(String fileName) {
        return LogFileNames.getNthElementFromFileName(fileName, 4);
    }

    public static String forMessageLog(long tokenId, long nodeId) {
        return tokenId + "-" + nodeId + "-messageLog";
    }

    public static void sortFiles(File[] files, String sortColumn, final boolean descending) {
        final SortColumnEnum column = sortColumn != null ? SortColumnEnum.valueOf(sortColumn) : null;
        Arrays.sort(files, 0, files.length, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (column == null || column.equals((Object)SortColumnEnum.timestamp)) {
                    return new Long(descending ? LogFileNames.extractFileTimestamp(o2.getName()) - LogFileNames.extractFileTimestamp(o1.getName()) : LogFileNames.extractFileTimestamp(o1.getName()) - LogFileNames.extractFileTimestamp(o2.getName())).intValue();
                }
                if (column.equals((Object)SortColumnEnum.incoming)) {
                    return descending ? LogFileNames.extractMessageIncoming(o1.getName()).compareTo(LogFileNames.extractMessageIncoming(o2.getName())) : LogFileNames.extractMessageIncoming(o2.getName()).compareTo(LogFileNames.extractMessageIncoming(o1.getName()));
                }
                if (column.equals((Object)SortColumnEnum.messageName)) {
                    return descending ? LogFileNames.extractMessageName(o2.getName()).compareTo(LogFileNames.extractMessageName(o1.getName())) : LogFileNames.extractMessageName(o1.getName()).compareTo(LogFileNames.extractMessageName(o2.getName()));
                }
                if (column.equals((Object)SortColumnEnum.messageType)) {
                    return descending ? LogFileNames.extractMessageType(o2.getName()).compareTo(LogFileNames.extractMessageType(o1.getName())) : LogFileNames.extractMessageType(o1.getName()).compareTo(LogFileNames.extractMessageType(o2.getName()));
                }
                if (column.equals((Object)SortColumnEnum.messageUID)) {
                    return descending ? LogFileNames.extractMessageUid(o2.getName()).compareTo(LogFileNames.extractMessageUid(o1.getName())) : LogFileNames.extractMessageUid(o1.getName()).compareTo(LogFileNames.extractMessageUid(o2.getName()));
                }
                return 0;
            }
        });
    }

    private static String getNthElementFromFileName(String fileName, int index) {
        String[] elements = fileName.split("-");
        if (index == Integer.MAX_VALUE) {
            index = elements.length - 2;
        } else if (index == 0x7FFFFFFE) {
            index = elements.length - 3;
        }
        return elements[index];
    }
}

