/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.common.util;

import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;

public class ExpressSearchUtil {
    private static ExpressSearchUtil instance = new ExpressSearchUtil();
    private static final Logger logger = Logger.getLogger(ExpressSearchUtil.class);

    private ExpressSearchUtil() {
    }

    public static ExpressSearchUtil getInstance() {
        return instance;
    }

    public List<WFSearchResult> searchChildren(SearchCriteria searchCriteria, Session session) {
        ArrayList<WFSearchResult> processes = new ArrayList<WFSearchResult>();
        String queryString = this.buildFetchChildrenQuery(searchCriteria);
        logger.debug((Object)("Executing search query:" + queryString));
        if (queryString != null) {
            SQLQuery query = session.createSQLQuery(queryString).addScalar("Lvl", (Type)Hibernate.INTEGER).addScalar("P_ID", (Type)Hibernate.LONG).addScalar("S_TOKEN", (Type)Hibernate.LONG).addScalar("RootTokenId", (Type)Hibernate.LONG).addScalar("T_ID", (Type)Hibernate.LONG).addScalar("ParentT_Id", (Type)Hibernate.LONG).addScalar("OperationalStatus", (Type)Hibernate.INTEGER).addScalar("AdministrativeStat", (Type)Hibernate.INTEGER).addScalar("StartTime", (Type)Hibernate.TIMESTAMP).addScalar("EndTime", (Type)Hibernate.TIMESTAMP).addScalar("TemplateName", (Type)Hibernate.STRING).addScalar("CurrentTask", (Type)Hibernate.STRING).addScalar("ErrorComment", (Type)Hibernate.STRING).addScalar("ErrorActorId", (Type)Hibernate.STRING).addScalar("ErrorTime", (Type)Hibernate.TIMESTAMP);
            query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
            List results = query.list();
            WFSearchResult topLevelParent = null;
            HashMap<Long, WFSearchResult> pidMap = new HashMap<Long, WFSearchResult>();
            for (Object object : results) {
                WFToken token;
                Map row = (Map)object;
                WFSearchResult wfsr = null;
                int hierarchyLevel = (Integer)row.get("Lvl");
                long procId = (Long)row.get("P_ID");
                if (topLevelParent == null && hierarchyLevel == 1) {
                    String idStr = searchCriteria.getParameter("id").getPredicate();
                    long searchId = Long.parseLong(idStr.substring(idStr.lastIndexOf(32) + 1));
                    if (searchId != procId) {
                        logger.error((Object)"Something is not right!");
                    }
                    wfsr = new WFSearchResult();
                    wfsr.setProcessDefinitionName((String)row.get("TemplateName"));
                    wfsr.setProcessId(procId);
                    wfsr.setProtectionKeys((String)row.get("ProtectionKey"));
                    wfsr.setRootTokenId(((Long)row.get("RootTokenId")).longValue());
                    token = new WFToken();
                    token.setAdministrativeStatus(((Integer)row.get("AdministrativeStat")).intValue());
                    token.setEndTime((Date)row.get("EndTime"));
                    token.setNodeName((String)row.get("CurrentTask"));
                    this.setNodeName(wfsr.getProcessDefinitionName(), token);
                    token.setOperationalStatus(((Integer)row.get("OperationalStatus")).intValue());
                    token.setStartTime((Date)row.get("StartTime"));
                    token.setTokenId(((Long)row.get("T_ID")).longValue());
                    token.setProcessId(procId);
                    this.setErrorComment(row, token);
                    token.setErrorComment((String)(row.get("ErrorComment") == null ? row.get("ErrorActorId") : row.get("ErrorComment")));
                    token.setErrorTime((Date)row.get("ErrorTime"));
                    wfsr.setToken(token);
                    topLevelParent = wfsr;
                    processes.add(wfsr);
                    pidMap.put(procId, wfsr);
                    continue;
                }
                if (hierarchyLevel <= 1) continue;
                if (row.get("ParentT_Id") == null && row.get("S_TOKEN") != null) {
                    wfsr = new WFSearchResult();
                    wfsr.setProcessDefinitionName((String)row.get("TemplateName"));
                    wfsr.setProcessId(procId);
                    wfsr.setProtectionKeys((String)row.get("ProtectionKey"));
                    wfsr.setRootTokenId(((Long)row.get("RootTokenId")).longValue());
                    WFToken token2 = new WFToken();
                    token2.setAdministrativeStatus(((Integer)row.get("AdministrativeStat")).intValue());
                    token2.setEndTime((Date)row.get("EndTime"));
                    token2.setNodeName((String)row.get("CurrentTask"));
                    this.setNodeName(wfsr.getProcessDefinitionName(), token2);
                    token2.setOperationalStatus(((Integer)row.get("OperationalStatus")).intValue());
                    token2.setStartTime((Date)row.get("StartTime"));
                    token2.setTokenId(((Long)row.get("T_ID")).longValue());
                    token2.setProcessId(procId);
                    this.setErrorComment(row, token2);
                    token2.setErrorTime((Date)row.get("ErrorTime"));
                    wfsr.setToken(token2);
                    long superTokenId = (Long)row.get("S_TOKEN");
                    WFToken superToken = topLevelParent.getChildTokenWithId(superTokenId);
                    WFSearchResult parentProc = (WFSearchResult)pidMap.get(superToken.getProcessId());
                    parentProc.addChild(wfsr);
                    pidMap.put(procId, wfsr);
                    continue;
                }
                long parentTokenId = (Long)row.get("ParentT_Id");
                WFToken parentToken = topLevelParent.getChildTokenWithId(parentTokenId);
                token = new WFToken();
                token.setAdministrativeStatus(((Integer)row.get("AdministrativeStat")).intValue());
                token.setEndTime((Date)row.get("EndTime"));
                token.setNodeName((String)row.get("CurrentTask"));
                this.setNodeName((String)row.get("TemplateName"), token);
                token.setOperationalStatus(((Integer)row.get("OperationalStatus")).intValue());
                token.setStartTime((Date)row.get("StartTime"));
                token.setTokenId(((Long)row.get("T_ID")).longValue());
                token.setProcessId(procId);
                this.setErrorComment(row, token);
                token.setErrorTime((Date)row.get("ErrorTime"));
                parentToken.addChild(token);
            }
        }
        return processes;
    }

    private void setErrorComment(Map row, WFToken token) {
        if (row.get("ErrorComment") == null) {
            if (ErrorCategory.CHILD_PROCESS_FAILED.name().equalsIgnoreCase((String)row.get("ErrorActorId"))) {
                token.setErrorComment("Subprocess ID " + token.getProcessId() + " failed");
            } else if (ErrorCategory.TIMEOUT.name().equalsIgnoreCase((String)row.get("ErrorActorId"))) {
                token.setErrorComment("Timed out at " + token.getNodeName());
            } else if (ErrorCategory.INFINITE_LOOP.name().equalsIgnoreCase((String)row.get("ErrorActorId"))) {
                token.setErrorComment("Loop exceeded iteration limit");
            }
        } else {
            token.setErrorComment((String)row.get("ErrorComment"));
        }
    }

    private String buildFetchChildrenQuery(SearchCriteria searchCriteria) {
        StringBuilder query = new StringBuilder();
        String idStr = searchCriteria.getParameter("id").getPredicate();
        long id = Long.parseLong(idStr.substring(idStr.lastIndexOf(32) + 1));
        boolean filterSubProcess = searchCriteria.getParameter("hidesubprocess") == null;
        query.append("SELECT LEVEL as Lvl, ");
        query.append(" p.id_ as P_ID, p.superprocesstoken_ S_TOKEN, p.roottoken_ as RootTokenId, t.id_ as T_ID, t.parent_ as ParentT_Id, t.operationalstatus AS OperationalStatus, t.administrativestatus as AdministrativeStat, p.start_ as StartTime, p.end_ as EndTime,");
        query.append(" d.name_ || ' - v' || d.version_ as TemplateName, n.name_ as CurrentTask, JC.Message_ as ErrorComment, JC.actorid_ as ErrorActorId, JC.time_ as ErrorTime");
        query.append(" FROM JBPM_TOKEN T, JBPM_PROCESSINSTANCE P, jbpm_processdefinition D, jbpm_node N, JBPM_COMMENT JC");
        query.append(" WHERE t.processInstance_ = p.id_");
        query.append(" AND d.id_ = p.processdefinition_ AND t.node_ = n.id_ AND T.ID_ = JC.Token_ (+) AND d.processdefinitiontypeid = 2 AND p.isActive = 1");
        query.append(" START WITH p.id_ = ").append(id);
        if (filterSubProcess) {
            query.append(" AND t.parent_ IS NULL");
        }
        query.append(" CONNECT BY t.parent_ = PRIOR t.id_");
        if (filterSubProcess) {
            query.append(" OR p.superprocesstoken_ = PRIOR t.id_");
        }
        query.append(" ORDER SIBLINGS BY p.id_, t.id_");
        return query.toString();
    }

    public List<WFSearchResult> expressSearch(SearchCriteria searchCriteria, Session session) {
        List searchParameters = searchCriteria.getSearchList();
        ArrayList<SearchParameterBase> whereParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> whereVariableParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortVariableParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortList = null;
        ArrayList<SearchParameterBase> whereList = null;
        for (SearchParameterBase param : searchParameters) {
            if (param.isVarInstance()) {
                sortList = sortVariableParameters;
                whereList = whereVariableParameters;
            } else {
                sortList = sortParameters;
                whereList = whereParameters;
            }
            if (param instanceof SortParameter) {
                sortList.add(param);
                continue;
            }
            if (param.getPartialWhereClause() == null) continue;
            whereList.add(param);
        }
        ArrayList<WFSearchResult> processes = new ArrayList<WFSearchResult>();
        HashMap<Long, WFSearchResult> pidMap = new HashMap<Long, WFSearchResult>();
        String queryString = this.buildTopLevelQuery(searchCriteria, whereParameters, sortParameters, whereVariableParameters, sortVariableParameters, false);
        logger.debug((Object)("Executing search query:" + queryString));
        if (queryString != null) {
            this.fillTopLevelResults(session, queryString, processes, pidMap);
        }
        logger.debug((Object)("Search Result:" + processes.size() + " Processes"));
        int ORA_01795_LIMIT = 1000;
        int pidCount = 0;
        StringBuilder pids = new StringBuilder();
        Iterator itr = pidMap.keySet().iterator();
        while (itr.hasNext()) {
            if (pids.length() > 0) {
                pids.append(", ");
            }
            pids.append(itr.next());
            if (++pidCount < 1000) continue;
            this.fillVariables(pids.toString(), session, pidMap);
            pids.delete(0, pids.length());
            pidCount = 0;
        }
        this.fillVariables(pids.toString(), session, pidMap);
        return processes;
    }

    private String buildTopLevelQuery(SearchCriteria searchCriteria, List<SearchParameterBase> whereParameters, List<SearchParameterBase> sortParameters, List<SearchParameterBase> whereVariableParameters, List<SearchParameterBase> sortVariableParameters, boolean forCount) {
        StringBuilder query = new StringBuilder();
        boolean sortByIdFound = false;
        boolean firstOrderBy = true;
        if (forCount) {
            query.append("SELECT COUNT(*) as TOTALCOUNT");
        } else {
            String orderByClause;
            query.append("SELECT * FROM ( SELECT row_number() over (");
            query.append(" ORDER BY ");
            for (SearchParameterBase param : sortVariableParameters) {
                orderByClause = "";
                switch (param.getFieldType()) {
                    case STRING: {
                        orderByClause = "v_s.STRINGVALUE_";
                        break;
                    }
                    case NUMERIC: {
                        orderByClause = "v_s.LONGVALUE_";
                        break;
                    }
                    case DATE: {
                        orderByClause = "v_s.DATEVALUE_";
                        break;
                    }
                    default: {
                        orderByClause = "v_s.STRINGVALUE_";
                    }
                }
                if (orderByClause.length() <= 0) continue;
                query.append(firstOrderBy ? "" : ", ").append(orderByClause).append(SortingOrder.DESCENDING.equals((Object)param.getSortingOrder()) ? " DESC NULLS FIRST " : " ASC NULLS LAST ");
                firstOrderBy = false;
            }
            for (SearchParameterBase param : sortParameters) {
                orderByClause = "";
                if ("id".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.id_";
                    sortByIdFound = true;
                } else if ("start".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.start_";
                } else if ("end".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.end_";
                } else if ("workOrderTemplate".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "d.name_";
                } else if ("processDefinition.id".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "d.id_";
                } else if ("priority".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.processpriorityid";
                } else if ("status".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.operationalprocessstatusid";
                } else if ("requestedStatus".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "p.administrativeprocessstatusid";
                } else if ("rootToken.node.name".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "n.name_";
                } else if ("processDefinition.name".equalsIgnoreCase(param.getFieldName())) {
                    orderByClause = "d.name_";
                } else {
                    logger.info((Object)("Missed out condition - " + param.getFieldName() + ", " + param.getSortingColumn()));
                    continue;
                }
                if (orderByClause.length() <= 0) continue;
                query.append(firstOrderBy ? "" : ", ").append(orderByClause).append(SortingOrder.DESCENDING.equals((Object)param.getSortingOrder()) ? " DESC NULLS LAST " : " ASC NULLS FIRST ");
                firstOrderBy = false;
            }
            if (!sortByIdFound) {
                query.append(firstOrderBy ? "" : ",").append(" p.id_ DESC");
            }
            query.append(") as RNUM, count(1) over () as TOTALCOUNT,");
            query.append(" p.id_ as P_ID, p.superprocesstoken_ S_TOKEN, p.roottoken_ as RootTokenId, t.id_ as T_ID, t.parent_ as ParentT_Id, t.operationalstatus AS OperationalStatus, t.administrativestatus as AdministrativeStat, p.start_ as StartTime, p.end_ as EndTime,");
            query.append(" d.name_ || ' - v' || d.version_ as TemplateName, n.name_ as CurrentTask, l.ProtKey as ProtectionKey, JC.Message_ as ErrorComment, JC.actorid_ as ErrorActorId, JC.time_ as ErrorTime");
        }
        query.append(" FROM JBPM_TOKEN T, JBPM_PROCESSINSTANCE P, jbpm_processdefinition D, jbpm_node N, JBPM_COMMENT JC");
        query.append(", (SELECT LISTAGG(al.name, ',') WITHIN GROUP (ORDER BY ll.processdefinitionid) as ProtKey, ll.processdefinitionid");
        query.append(" FROM TTV_PROCDEFACCESSLEVEL LL, TTV_ACCESSLEVEL AL");
        query.append(" WHERE LL.accesslevelid = AL.accesslevelid");
        for (SearchParameterBase param : whereParameters) {
            if (!"AccessLevel".equalsIgnoreCase(param.getFieldName())) continue;
            query.append(" AND ll.accesslevelid ").append(param.getPredicate());
        }
        query.append(" GROUP BY ll.processdefinitionid) L");
        int i = 0;
        while (i < whereVariableParameters.size()) {
            query.append(", JBPM_VARIABLEINSTANCE V").append(i);
            ++i;
        }
        if (!forCount && sortVariableParameters.size() > 0) {
            query.append(", JBPM_VARIABLEINSTANCE V_s");
        }
        query.append(" WHERE t.processInstance_ = p.id_");
        query.append(" AND d.id_ = p.processdefinition_ AND t.node_ = n.id_ AND d.id_ = l.processdefinitionid (+) AND T.ID_ = JC.Token_ (+)");
        query.append(" AND d.processdefinitiontypeid = 2 AND p.isActive = 1 AND t.parent_ IS NULL");
        if (searchCriteria.getParameter("hidesubprocess") != null) {
            query.append(" AND p.superprocesstoken_ IS NULL");
        }
        i = 0;
        while (i < whereVariableParameters.size()) {
            SearchParameterBase param = whereVariableParameters.get(i);
            query.append(" AND v").append(i).append(".processinstance_ (+)= p.id_ AND ");
            if (param.getClass().getName().equalsIgnoreCase("com.tandbergtv.watchpoint.pmm.title.activity.TitleKeysParameter") && param.getFieldName().equalsIgnoreCase("titleID")) {
                query.append(" (v").append(i).append(".name_ (+)= 'titleId' AND ");
                String partWC = param.getPartialWhereClause();
                if (partWC.indexOf(".stringVal is not null") > 0) {
                    query.append(" v").append(i).append(".STRINGVALUE_ IS NOT NULL ");
                } else {
                    partWC = partWC.substring(partWC.indexOf(".stringVal in (") + 15);
                    partWC = partWC.substring(0, partWC.indexOf(41));
                    query.append(" v").append(i).append(".STRINGVALUE_ ");
                    if (partWC.indexOf(44) > 0) {
                        query.append("IN (").append(partWC).append(")");
                    } else {
                        query.append("= ").append(partWC);
                    }
                }
                query.append(")");
            } else {
                query.append(" (v").append(i).append(".name_ (+)");
                if (param.getFieldName().contains("%")) {
                    query.append("LIKE ");
                } else {
                    query.append("= ");
                }
                query.append("'").append(param.getFieldName()).append("' AND ");
                switch (param.getFieldType()) {
                    case STRING: {
                        query.append(" v").append(i).append(".STRINGVALUE_ ").append(param.getPredicate());
                        break;
                    }
                    case NUMERIC: {
                        query.append(" v").append(i).append(".LONGVALUE_ ").append(param.getPredicate());
                        break;
                    }
                    case DATE: {
                        query.append(" v").append(i).append(".DATEVALUE_ ").append(param.getPredicate());
                        break;
                    }
                    default: {
                        query.append(" v").append(i).append(".STRINGVALUE_ ").append(param.getPredicate());
                    }
                }
                query.append(")");
            }
            ++i;
        }
        if (!forCount && sortVariableParameters.size() > 0) {
            for (SearchParameterBase param : sortVariableParameters) {
                query.append(" AND v_s.processinstance_ (+)= p.id_ AND (v_s.name_ (+)= '").append(param.getFieldName()).append("')");
            }
        }
        for (SearchParameterBase param : whereParameters) {
            if ("id".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.id_ ").append(param.getPredicate());
                continue;
            }
            if ("tokenId".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND t.id_ ").append(param.getPredicate());
                continue;
            }
            if ("start".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.start_ ").append(param.getPredicate());
                continue;
            }
            if ("end".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.end_ ").append(param.getPredicate());
                continue;
            }
            if ("processDefinition.id".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND d.id_ ").append(param.getPredicate());
                continue;
            }
            if ("priority".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.processpriorityid ").append(param.getPredicate());
                continue;
            }
            if ("status".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.operationalprocessstatusid ");
                query.append(param.getPartialWhereClause().substring(param.getPartialWhereClause().indexOf("IN")));
                continue;
            }
            if ("requestedStatus".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND p.administrativeprocessstatusid ");
                query.append(param.getPartialWhereClause().substring(param.getPartialWhereClause().indexOf("IN")));
                continue;
            }
            if ("rootToken.node.name".equalsIgnoreCase(param.getFieldName())) {
                query.append(" AND n.name_ ").append(param.getPredicate());
                continue;
            }
            logger.debug((Object)("Missed out condition - " + param.getFieldName() + ", " + param.getPartialWhereClause()));
        }
        if (!forCount) {
            query.append(") B ");
            if (searchCriteria.getRecordsCount() > 0) {
                query.append(" WHERE B.RNUM BETWEEN ").append(searchCriteria.getStartingRecordNumber() + 1).append(" AND ").append(searchCriteria.getStartingRecordNumber() + searchCriteria.getRecordsCount());
            }
        }
        return query.toString();
    }

    private void fillTopLevelResults(Session session, String queryString, List<WFSearchResult> processes, Map<Long, WFSearchResult> pidMap) {
        SQLQuery query = session.createSQLQuery(queryString).addScalar("TOTALCOUNT", (Type)Hibernate.LONG).addScalar("RNUM", (Type)Hibernate.LONG).addScalar("P_ID", (Type)Hibernate.LONG).addScalar("S_TOKEN", (Type)Hibernate.LONG).addScalar("RootTokenId", (Type)Hibernate.LONG).addScalar("T_ID", (Type)Hibernate.LONG).addScalar("ParentT_Id", (Type)Hibernate.LONG).addScalar("OperationalStatus", (Type)Hibernate.INTEGER).addScalar("AdministrativeStat", (Type)Hibernate.INTEGER).addScalar("StartTime", (Type)Hibernate.TIMESTAMP).addScalar("EndTime", (Type)Hibernate.TIMESTAMP).addScalar("TemplateName", (Type)Hibernate.STRING).addScalar("CurrentTask", (Type)Hibernate.STRING).addScalar("ProtectionKey", (Type)Hibernate.STRING).addScalar("ErrorComment", (Type)Hibernate.STRING).addScalar("ErrorActorId", (Type)Hibernate.STRING).addScalar("ErrorTime", (Type)Hibernate.TIMESTAMP);
        query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        List results = query.list();
        for (Object object : results) {
            Map row = (Map)object;
            WFSearchResult wfsr = null;
            long procId = (Long)row.get("P_ID");
            wfsr = pidMap.get(procId);
            if (wfsr == null) {
                wfsr = new WFSearchResult();
                wfsr.setProcessId(procId);
                wfsr.setProcessDefinitionName((String)row.get("TemplateName"));
                wfsr.setProtectionKeys((String)row.get("ProtectionKey"));
                wfsr.setRootTokenId(((Long)row.get("RootTokenId")).longValue());
                wfsr.setSearchResultCount(((Long)row.get("TOTALCOUNT")).longValue());
                WFToken token = new WFToken();
                token.setAdministrativeStatus(((Integer)row.get("AdministrativeStat")).intValue());
                token.setEndTime((Date)row.get("EndTime"));
                token.setNodeName((String)row.get("CurrentTask"));
                this.setNodeName(wfsr.getProcessDefinitionName(), token);
                token.setOperationalStatus(((Integer)row.get("OperationalStatus")).intValue());
                token.setStartTime((Date)row.get("StartTime"));
                token.setTokenId(((Long)row.get("T_ID")).longValue());
                token.setProcessId(procId);
                this.setErrorComment(row, token);
                token.setErrorTime((Date)row.get("ErrorTime"));
                wfsr.setToken(token);
                processes.add(wfsr);
                pidMap.put(procId, wfsr);
                continue;
            }
            logger.error((Object)("More than one rows were returned for WO[" + procId + "]. The query needs correction."));
        }
    }

    private void setNodeName(String templateName, final WFToken token) {
        ITemplateLoaderService templateLoaderService = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        WorkflowTemplate template = templateLoaderService.getTemplateByFullName(templateName);
        if (template != null) {
            template.breadthFirstTraversal(new NodeVisitor(){

                public void visit(Node node) {
                    Node currentNode;
                    if (node instanceof SuperState && (currentNode = ((SuperState)node).getNode(token.getNodeName())) != null) {
                        token.setNodeName(node.getName());
                    }
                }
            });
        }
    }

    private void fillVariables(String pids, Session session, Map<Long, WFSearchResult> pidMap) {
        if (pids.length() < 1) {
            return;
        }
        String queryString2 = this.buildVariablesQuery(pids);
        SQLQuery query2 = session.createSQLQuery(queryString2).addScalar("PROCESSINSTANCE_", (Type)Hibernate.LONG).addScalar("ID_", (Type)Hibernate.LONG).addScalar("CLASS_", (Type)Hibernate.CHARACTER).addScalar("NAME_", (Type)Hibernate.STRING).addScalar("CONVERTER_", (Type)Hibernate.STRING).addScalar("TOKEN_", (Type)Hibernate.LONG).addScalar("STRINGVALUE_", (Type)Hibernate.STRING).addScalar("LONGVALUE_", (Type)Hibernate.LONG).addScalar("DOUBLEVALUE_", (Type)Hibernate.DOUBLE);
        query2.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
        List varResults = query2.list();
        for (Object object : varResults) {
            Map row = (Map)object;
            String varName = (String)row.get("NAME_");
            String value = null;
            WFVariable var = new WFVariable();
            var.setName(varName);
            switch (((Character)row.get("CLASS_")).charValue()) {
                case 'S': {
                    value = (String)row.get("STRINGVALUE_");
                    break;
                }
                case 'L': {
                    if (row.get("LONGVALUE_") == null) {
                        if (row.get("DOUBLEVALUE_") == null) {
                            value = null;
                            break;
                        }
                        value = Double.toString((Double)row.get("DOUBLEVALUE_"));
                        break;
                    }
                    value = Long.toString((Long)row.get("LONGVALUE_"));
                    break;
                }
                case 'D': {
                    if (row.get("DATEVALUE_") == null) break;
                    value = ((Date)row.get("DATEVALUE_")).toString();
                    break;
                }
            }
            var.addValue(value);
            long pid = (Long)row.get("PROCESSINSTANCE_");
            WFSearchResult sr = pidMap.get(pid);
            sr.addVariable(var);
        }
        logger.debug((Object)"Processes filled with variables");
    }

    private String buildVariablesQuery(String commaSeparatedPIDList) {
        StringBuilder query = new StringBuilder();
        query.append("select * from jbpm_variableinstance v where v.processinstance_ in (").append(commaSeparatedPIDList).append(") ");
        return query.toString();
    }

    public int expressCount(SearchCriteria searchCriteria, Session session) {
        int count = 0;
        List searchParameters = searchCriteria.getSearchList();
        ArrayList<SearchParameterBase> whereParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> whereVariableParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortVariableParameters = new ArrayList<SearchParameterBase>();
        ArrayList<SearchParameterBase> sortList = null;
        ArrayList<SearchParameterBase> whereList = null;
        for (SearchParameterBase param : searchParameters) {
            if (param.isVarInstance()) {
                sortList = sortVariableParameters;
                whereList = whereVariableParameters;
            } else {
                sortList = sortParameters;
                whereList = whereParameters;
            }
            if (param instanceof SortParameter) {
                sortList.add(param);
                continue;
            }
            if (param.getPartialWhereClause() == null) continue;
            whereList.add(param);
        }
        String queryString = this.buildTopLevelQuery(searchCriteria, whereParameters, sortParameters, whereVariableParameters, sortVariableParameters, true);
        logger.debug((Object)("Executing search query:" + queryString));
        if (queryString != null) {
            SQLQuery query = session.createSQLQuery(queryString).addScalar("TOTALCOUNT", (Type)Hibernate.INTEGER);
            query.setResultTransformer(Criteria.ALIAS_TO_ENTITY_MAP);
            List results = query.list();
            if (results != null && results.get(0) != null) {
                Map row = (Map)results.get(0);
                count = (Integer)row.get("TOTALCOUNT");
            }
        }
        logger.debug((Object)("Found " + count + " Processes"));
        return count;
    }
}

