/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.preferences;

import com.tandbergtv.workflow.core.service.preferences.IUserPreferenceManager;
import com.tandbergtv.workflow.core.service.preferences.internal.DefaultUserPreferenceManager;
import java.util.Iterator;
import java.util.ServiceLoader;

public class UserPreferenceManagerFactory {
    public static UserPreferenceManagerFactory newInstance() {
        return new UserPreferenceManagerFactory();
    }

    protected UserPreferenceManagerFactory() {
    }

    public IUserPreferenceManager newUserPreferenceManager() {
        ServiceLoader<IUserPreferenceManager> loader;
        Iterator<IUserPreferenceManager> iterator;
        IUserPreferenceManager manager = null;
        String name = IUserPreferenceManager.class.getName();
        String className = System.getProperty(name);
        manager = className != null ? this.loadUserPreferenceManager(className) : ((iterator = (loader = ServiceLoader.load(IUserPreferenceManager.class)).iterator()).hasNext() ? iterator.next() : new DefaultUserPreferenceManager());
        return manager;
    }

    private IUserPreferenceManager loadUserPreferenceManager(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> managerClass = Class.forName(className, true, loader);
            return (IUserPreferenceManager)IUserPreferenceManager.class.cast(managerClass.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + IUserPreferenceManager.class.getName() + " implementation: " + className + ", error: " + e.getLocalizedMessage(), e);
        }
    }
}

