/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.boot;

import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.internal.CompositeCache;
import com.tandbergtv.workflow.core.service.internal.DistributedQueueService;
import com.tandbergtv.workflow.core.service.internal.DistributedScheduler;
import com.tandbergtv.workflow.core.service.internal.RecoverableDistributedScheduler;
import com.tandbergtv.workflow.core.service.queue.IDistributedQueueService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.EngineDriver;
import com.tandbergtv.workflow.driver.NodeLogListener;
import com.tandbergtv.workflow.driver.boot.clusteredservices.HistoryLoggingManager;
import com.tandbergtv.workflow.driver.command.buffer.DelayedCommandService;
import com.tandbergtv.workflow.driver.command.buffer.IDelayedCommandService;
import com.tandbergtv.workflow.driver.internal.DefaultProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.internal.HibernatePersistenceService;
import com.tandbergtv.workflow.driver.internal.MessageQueueService;
import com.tandbergtv.workflow.driver.internal.ProcessManager;
import com.tandbergtv.workflow.driver.internal.TaskCompletionService;
import com.tandbergtv.workflow.driver.internal.monitor.ManualTaskAlarmNotificationProvider;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessAlarmNotificationProvider;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.monitor.IStatistics;
import com.tandbergtv.workflow.driver.search.SearchService;
import com.tandbergtv.workflow.driver.search.TokenSearchService;
import com.tandbergtv.workflow.driver.service.IMessageQueueService;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.service.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.service.ITaskCompletionService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import com.tandbergtv.workflow.driver.task.ITaskAssignmentValidationService;
import com.tandbergtv.workflow.driver.task.internal.TaskAssignmentValidationService;
import com.tandbergtv.workflow.driver.template.TemplateLoaderService;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import com.tandbergtv.workflow.driver.timer.TimerManager;
import com.tandbergtv.workflow.log.LogSyncService;
import com.tandbergtv.workflow.log.LogZipService;
import com.tandbergtv.workflow.log.WorkflowLogManager;
import com.tandbergtv.workflow.log.WorkflowLogService;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationService;
import com.tandbergtv.workflow.monitor.event.IEventHandlerRegistry;
import com.tandbergtv.workflow.util.license.LicenseKeyConstants;
import com.tandbergtv.workflow.util.license.LicenseManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class Activator {
    private static final String PROCESS_MONITOR_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=Cumulative";
    private static final String PROCESS_MONITOR_CURRENT_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=Current";
    private static final String PROCESS_MONITOR_TOKENS_MBEAN_NAME = "com.tandbergtv.watchpoint:type=ProcessMonitor,name=CurrentBranched";
    private static final Logger logger = Logger.getLogger(Activator.class);

    public void start() {
        this.initializeJbpmTypes();
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".driver");
        EngineDriver driver = EngineDriver.getInstance();
        DefaultMediator.getInstance().register((IColleague)driver);
        IEventHandlerRegistry handlers = this.getService(IEventHandlerRegistry.class);
        handlers.registerEventHandler(new NodeLogListener());
        int size = Integer.parseInt(bundle.getString("driver.cache.size"));
        CompositeCache cache = new CompositeCache(bundle.getString("driver.cache.name"), size);
        this.addService((Service)cache);
        SessionFactory factory = HibernateUtil.getSessionFactory();
        this.addService((Service)new SearchService(factory));
        Properties properties = new Properties();
        properties.setProperty("template.max.count", Integer.toString(this.getMaxTemplateCount()));
        this.addService((Service)new TemplateLoaderService(properties, factory));
        this.addService((Service)new TokenSearchService(factory));
        this.addService((Service)new HibernatePersistenceService(factory));
        this.addService((Service)new RecoverableDistributedScheduler("distributed-scheduler", 4));
        this.addService((Service)new DistributedScheduler("one-shot-distributed-scheduler", 8));
        this.addService((Service)new TaskCompletionService());
        this.addService((Service)new TimerManager());
        this.addService(new DelayedCommandService());
        this.addService((Service)new DistributedQueueService("distributed-queue"));
        this.addService((Service)new MessageQueueService());
        this.addService((Service)new DefaultProgressTrackingStrategy());
        this.addService(new TaskAssignmentValidationService());
        int core = Integer.parseInt(bundle.getString("messages.pool.size"));
        int max = Integer.parseInt(bundle.getString("messages.pool.max"));
        HistoryLoggingManager hlMgr = new HistoryLoggingManager();
        Properties props = hlMgr.getProperties();
        try {
            max = core = Integer.parseInt(props.getProperty("pool.size"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.addService((Service)new Scheduler("message-thread", core, max));
        ProcessManager service = new ProcessManager(props);
        this.registerMBeans((IProcessManagerService)service);
        ServiceRegistry.getDefault().register(service.getServiceName(), (Service)service);
        service.start();
        this.getService(IAlarmNotificationService.class).addProvider((IAlarmNotificationProvider)new ProcessAlarmNotificationProvider());
        this.getService(IAlarmNotificationService.class).addProvider((IAlarmNotificationProvider)new ManualTaskAlarmNotificationProvider());
        hlMgr.startServices();
        if (Cluster.isMaster()) {
            service.recover();
        }
    }

    public void stop() {
        this.removeService(LogSyncService.class);
        this.removeService(WorkflowLogService.class);
        this.removeService(WorkflowLogManager.class);
        this.removeService(LogZipService.class);
        ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".driver");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_MBEAN_NAME));
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_CURRENT_MBEAN_NAME));
            server.unregisterMBean(new ObjectName(PROCESS_MONITOR_TOKENS_MBEAN_NAME));
        }
        catch (Exception e) {
            logger.warn((Object)"ProcessMonitor MBean unregistration failed");
        }
        EngineDriver driver = EngineDriver.getInstance();
        DefaultMediator.getInstance().unregister((IColleague)driver);
        this.removeService(IProcessManagerService.class);
        this.removeService(ITaskAssignmentValidationService.class);
        this.removeService(IProgressTrackingStrategy.class);
        this.removeService(ITimerService.class);
        this.removeService(IMessageQueueService.class);
        this.removeService(IDistributedQueueService.class);
        this.removeService(IDelayedCommandService.class);
        this.removeService("message-thread");
        this.removeService(ITaskCompletionService.class);
        this.removeService("one-shot-distributed-scheduler");
        this.removeService("distributed-scheduler");
        this.removeService(ITemplateLoaderService.class);
        this.removeService(IPersistenceService.class);
        this.removeService(ITokenSearchService.class);
        this.removeService(IProcessSearchService.class);
        this.removeService(bundle.getString("driver.cache.name"));
        logger.info((Object)"Process execution runtime destroyed");
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = (Service)registry.lookup(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private void removeService(String name) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = registry.lookup(name);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }

    private int getMaxTemplateCount() {
        int count = Integer.MAX_VALUE;
        try {
            String entry = LicenseManager.getInstance().getObject(LicenseKeyConstants.TEMPLATES);
            if (entry != null && entry.trim().length() > 0) {
                count = Integer.parseInt(entry.trim());
            }
        }
        catch (Exception e) {
            count = 0;
        }
        return count;
    }

    private void registerMBeans(IProcessManagerService service) {
        IStatistics statistics = service.getStatistics();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            StandardMBean mbean = new StandardMBean(statistics.getCumulativeStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_MBEAN_NAME));
            mbean = new StandardMBean(statistics.getProcessStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_CURRENT_MBEAN_NAME));
            mbean = new StandardMBean(statistics.getTokenStatistics(), IProcessMonitor.class);
            server.registerMBean(mbean, new ObjectName(PROCESS_MONITOR_TOKENS_MBEAN_NAME));
        }
        catch (Exception e) {
            logger.warn((Object)"Registration of MBean failed, monitoring will not be available", (Throwable)e);
        }
    }

    private void initializeJbpmTypes() {
        String resource = JbpmConfiguration.Configs.getString((String)"resource.varmapping");
        InputStream is = ClassLoaderUtil.getStream((String)resource);
        Element rootElement = XmlUtil.parseXmlInputStream((InputStream)is).getDocumentElement();
        ObjectInfo oi = new ObjectFactoryParser().parse(XmlUtil.element((Element)rootElement, (String)"list"));
        ObjectFactoryImpl of = (ObjectFactoryImpl)JbpmConfiguration.Configs.getObjectFactory();
        of.addObjectInfo(oi);
        try {
            is.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

