/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.driver.boot.EngineDriverProperties;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEventLogger;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ResourceEventHistoryRemover
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ResourceEventHistoryRemover.class);
    private static final String PROP_RESOURCE_EVENT_HISTORY_RETENTION = "history.resourceEvent.retention.days";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private int historyRetentionDays = 7;

    public ResourceEventHistoryRemover() {
        this.initEventHistoryProperties();
    }

    private void initEventHistoryProperties() {
        EngineDriverProperties props = new EngineDriverProperties();
        String retentionDays = props.getProperty(PROP_RESOURCE_EVENT_HISTORY_RETENTION);
        if (retentionDays != null) {
            this.historyRetentionDays = Integer.valueOf(retentionDays);
        }
    }

    @Override
    public void run() {
        if (Cluster.isMaster()) {
            Calendar now = Calendar.getInstance();
            now.add(6, -this.historyRetentionDays);
            LOGGER.info((Object)("Deleting all resource event history from " + dateFormat.format(now.getTime()) + " and before."));
            ResourceHeartBeatEventLogger eventLogger = new ResourceHeartBeatEventLogger();
            File resoureHistoryDir = new File(eventLogger.getBaseResourceHistoryPath());
            if (resoureHistoryDir.isDirectory()) {
                File[] resourceDateDirs = resoureHistoryDir.listFiles();
                for (int i = 0; i < resourceDateDirs.length; ++i) {
                    File dir = resourceDateDirs[i];
                    int dateStartIndex = dir.toString().lastIndexOf(File.separator) + 1;
                    String dirDateStr = dir.toString().substring(dateStartIndex, dir.toString().length());
                    try {
                        Date resourceHistoryDirDate = dateFormat.parse(dirDateStr);
                        if (!dir.isDirectory() || !resourceHistoryDirDate.before(now.getTime())) continue;
                        LOGGER.info((Object)("Removing resource history folder " + dir));
                        Directories.delete(dir);
                        continue;
                    }
                    catch (ParseException pe) {
                        LOGGER.info((Object)("Unable to parse date: " + dirDateStr + ", skipping delete..."));
                    }
                }
            }
        }
    }
}

