/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.watch;

import com.tandbergtv.watchpoint.watchfolder.core.FileInfo;
import com.tandbergtv.watchpoint.watchfolder.core.IProcess;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import java.io.File;
import org.apache.log4j.Logger;

public abstract class AbstractFileListener
implements IProcess {
    private static final Logger logger = Logger.getLogger(AbstractFileListener.class);

    protected AbstractFileListener() {
    }

    public void fileCreated(FileInfo fileInfo) {
        String path = fileInfo.getAbsolutePath();
        File file = new File(path);
        if (!Cluster.owner((Object)file.getName())) {
            return;
        }
        this.preCreate(file);
        ITemplateReader reader = this.getReader(file);
        ITemplateLoaderService service = (ITemplateLoaderService)ServiceRegistry.getDefault().lookup(ITemplateLoaderService.class);
        service.runCompiler(file, reader);
    }

    public void fileDeleted(FileInfo fileInfo) {
        logger.warn((Object)"Ignoring file deleted event");
    }

    public void fileUpdated(FileInfo fileInfo) {
        logger.warn((Object)"Ignoring file updated event");
    }

    protected void preCreate(File file) {
        logger.info((Object)("New file " + file.getAbsolutePath()));
    }

    protected abstract ITemplateReader getReader(File var1);
}

