/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.file;

import com.tandbergtv.workflow.log.file.FileNameMatcher;
import java.io.File;
import java.io.FilenameFilter;

public class Directories {
    private static final long MAX_CONSTANT = 10000L;

    public static File[] list(File dir, final FileNameMatcher matcher) {
        if (dir == null || !dir.isDirectory() || matcher == null) {
            throw new IllegalArgumentException();
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return matcher.match(name);
            }
        });
    }

    public static File[] list(File dir, final FileNameMatcher ... matchers) {
        if (dir == null || !dir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        if (matchers == null || matchers.length == 0) {
            return new File[0];
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean match = true;
                for (FileNameMatcher matcher : matchers) {
                    match = match && matcher.match(name);
                }
                return match;
            }
        });
    }

    public static File directoryFor(String root, long id) {
        return new File(Directories.pathFor(root, id));
    }

    public static String pathFor(String root, long id) {
        if ((double)id > Math.pow(10000.0, 3.0)) {
            throw new Error("ID " + id + " exceeded limit");
        }
        int l1 = (int)Math.ceil((double)id / 1.0E8);
        int l2 = (int)Math.ceil((double)id / 10000.0);
        return root + File.separator + l1 + File.separator + l2 + File.separator + id + File.separator;
    }

    public static void delete(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        for (File file : dir.listFiles()) {
            Directories.deleteRecursively(file);
        }
        dir.delete();
    }

    private static void deleteRecursively(File f) {
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                Directories.deleteRecursively(file);
            }
        }
        f.delete();
    }
}

