/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.resource;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.dao.hibernate.HibernateUtil;
import com.tandbergtv.workflow.driver.internal.AuthorizationManager;
import com.tandbergtv.workflow.driver.service.IAuthorizationManager;
import com.tandbergtv.workflow.monitor.Observers;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.IRecorder;
import com.tandbergtv.workflow.monitor.internal.MetricProcessor;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManager;
import com.tandbergtv.workflow.util.license.InvalidLicenseException;
import com.tandbergtv.workflow.util.license.LicenseKeyConstants;
import com.tandbergtv.workflow.util.license.LicenseManager;
import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.management.ManagementService;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

public class Activator {
    private static final String MBEAN_QUERY = "com.tandbergtv.watchpoint:type=Queue,*";

    public void start() {
        ManagementService.registerMBeans((CacheManager)CacheManager.getInstance(), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        SessionFactory factory = HibernateUtil.getSessionFactory();
        this.addService((Service)new AuthorizationManager(factory));
        int system = this.getMaxResourceCount(LicenseKeyConstants.SYSTEM_RESOURCES);
        int human = this.getMaxResourceCount(LicenseKeyConstants.HUMAN_RESOURCE);
        this.addService((Service)new ResourceManager(factory, system, human));
        this.addObserver();
    }

    public void stop() {
        this.removeService(ResourceManagement.class);
        this.removeService(IAuthorizationManager.class);
        CacheManager.getInstance().shutdown();
    }

    private int getMaxResourceCount(String category) {
        int result = Integer.MAX_VALUE;
        LicenseManager lm = LicenseManager.getInstance();
        try {
            String string = lm.getObject(category);
            if (string == null || string.trim().length() == 0) {
                return result;
            }
            result = Integer.parseInt(string.trim());
            if (result < 0) {
                throw new RuntimeException("Invalid license - " + category + " must be a positive value");
            }
        }
        catch (InvalidLicenseException e) {
            throw new RuntimeException("Invalid license", e);
        }
        return result;
    }

    private void addObserver() {
        IRecorder recorder = (IRecorder)ServiceRegistry.getDefault().lookup("fs-recorder");
        try {
            IObserver observer = Observers.localJMXObserver((String)MBEAN_QUERY, (String)"Size");
            recorder.addObserver(observer);
            this.getService(MetricProcessor.class).addMetricNames(observer.getMetricNames());
        }
        catch (JMException e) {
            Logger.getLogger(Activator.class).warn((Object)":(", (Throwable)e);
        }
    }

    private <T> T getService(Class<T> clazz) {
        return (T)ServiceRegistry.getDefault().lookup(clazz);
    }

    private void addService(Service service) {
        ServiceRegistry.getDefault().register(service.getServiceName(), service);
        service.start();
    }

    private void removeService(Class<? extends Service> clazz) {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        Service service = this.getService(clazz);
        if (service != null) {
            service.stop();
            registry.unregister(service);
        }
    }
}

