/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.adaptor.IAdaptorService;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.event.ProcessLogEvent;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.JSONConverter;
import com.tandbergtv.workflow.message.IMessageUID;
import com.tandbergtv.workflow.message.event.WorkflowMessageLogEvent;
import com.tandbergtv.workflow.message.registry.IMessageRegistry;
import com.tandbergtv.workflow.message.util.Marshaller;
import com.tandbergtv.workflow.resourcemanager.event.WorkflowProcessStatusLogEvent;
import com.tandbergtv.workflow.util.XMLDocumentUtility;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.log.NodeLog;
import org.w3c.dom.Document;

public class EventSerializer {
    private String dir;
    public static Logger logger = Logger.getLogger(EventSerializer.class);

    public EventSerializer(String dir) {
        this.dir = dir;
    }

    public void serialize(WorkflowMessageLogEvent event) {
        long id = event.getToken().getProcessInstance().getId();
        long tokenId = event.getToken().getId();
        long timestamp = event.getTimestamp().getTime();
        try {
            HashMap<String, Object> serialized = new HashMap<String, Object>();
            serialized.put("messageUID", event.getWfsMessage().getMessageUID().getUID());
            serialized.put("messageType", event.getWfsMessage().getType().name());
            IMessageRegistry registry = ((IAdaptorService)ServiceRegistry.getDefault().lookup(IAdaptorService.class)).getMessageRegistry();
            String uid = event.getWfsMessage().getMessageUID().getUID();
            IMessageUID messageUID = registry != null ? registry.getMessageUID(uid) : null;
            serialized.put("messageName", messageUID != null ? messageUID.getName() : "");
            Document document = Marshaller.newMarshaller().marshal(event.getWfsMessage());
            serialized.put("message", XMLDocumentUtility.convertToString(document));
            serialized.put("incoming", event.isIncoming());
            serialized.put("timestamp", timestamp);
            serialized.put("resourceId", event.getResource() != null ? Long.valueOf(event.getResource().getId()) : "");
            long nodeId = this.getResourceGroupAwareNode(event.getNode()).getId();
            serialized.put("nodeId", nodeId);
            serialized.put("tokenId", tokenId);
            serialized.put("id", timestamp);
            String name = timestamp + "-" + serialized.get("messageUID") + "-" + serialized.get("messageName") + "-" + serialized.get("messageType") + "-" + serialized.get("incoming") + "-" + tokenId + "-" + nodeId;
            String path = Directories.pathFor(this.dir, id) + name + "-messageLog";
            JSONConverter.write(serialized, new File(path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void serialize(ProcessLogEvent event) {
        NodeLog nodeLog = (NodeLog)event.getLog();
        long id = nodeLog.getToken().getProcessInstance().getId();
        long tokenId = nodeLog.getToken().getId();
        long timestamp = nodeLog.getDate().getTime();
        HashMap<String, Object> serialized = new HashMap<String, Object>();
        serialized.put("id", timestamp);
        serialized.put("startTime", nodeLog.getEnter() != null ? Long.valueOf(nodeLog.getEnter().getTime()) : "");
        serialized.put("endTime", nodeLog.getLeave() != null ? Long.valueOf(nodeLog.getLeave().getTime()) : "");
        serialized.put("nodeId", nodeLog.getNode().getId());
        serialized.put("tokenId", tokenId);
        String name = timestamp + "-" + tokenId + "-" + nodeLog.getNode().getId();
        String path = Directories.pathFor(this.dir, id) + name + "-nodeLog";
        JSONConverter.write(serialized, new File(path));
    }

    public void serialize(WorkflowProcessStatusLogEvent event) {
        HashMap<String, Object> serialized = new HashMap<String, Object>();
        long id = event.getToken().getProcessInstance().getId();
        long resourceId = 0L;
        if (event.getResource() != null) {
            resourceId = event.getResource().getId();
        }
        serialized.put("id", event.getEndTime().getTime());
        serialized.put("nodeId", event.getNode().getId());
        serialized.put("resourceGroupId", event.getResourceGroup().getId());
        serialized.put("resourceId", resourceId);
        serialized.put("startTime", event.getStartTime().getTime());
        serialized.put("endTime", event.getEndTime().getTime());
        serialized.put("operationalStatus", event.getOperationalStatus());
        serialized.put("adminStatus", event.getAdminStatus());
        serialized.put("queued", event.isQueued());
        serialized.put("tokenId", event.getToken().getId());
        String name = event.getEndTime().getTime() + "-" + event.getNode().getId();
        String path = Directories.pathFor(this.dir, id) + name + "-resourceLog";
        JSONConverter.write(serialized, new File(path));
    }

    private Node getResourceGroupAwareNode(Node node) {
        Node parent = node;
        while (parent.getSuperState() instanceof SuperState) {
            if (!((parent = parent.getSuperState()) instanceof NodeGroup)) continue;
            return parent;
        }
        return node;
    }
}

