/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.driver.event.ProcessLogEvent;
import com.tandbergtv.workflow.monitor.core.MetricSample;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.ObjectName;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.log.NodeLog;

public class NodeLogListener
implements IColleague {
    private static final String MBEAN_NAME_PREFIX = "com.tandbergtv.watchpoint:type=Node,name=";
    private ConcurrentMap<String, MetricSample> samples = new ConcurrentHashMap<String, MetricSample>();

    public String getColleagueName() {
        return "nodelog-listener";
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    public Collection<MetricSample> getMetricSamples() {
        return Collections.unmodifiableCollection(this.samples.values());
    }

    public void receive(WorkflowEvent event) {
        if (!this.handleEvent((EventObject)event)) {
            return;
        }
        NodeLog l = this.getNodeLog((EventObject)event);
        MetricSample sample = this.getSample(this.getQualifiedName(l.getNode()));
        sample.add(l.getDuration());
    }

    protected MetricSample getSample(String name) {
        MetricSample ms = new MetricSample(name);
        MetricSample sample = this.samples.putIfAbsent(name, ms);
        if (sample == null) {
            sample = ms;
            this.registerMBean(sample);
        }
        return sample;
    }

    protected String getQualifiedName(Node node) {
        return ((WorkflowTemplate)node.getProcessDefinition()).getFullName() + "/" + node.getName();
    }

    protected void registerMBean(MetricSample sample) {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(sample, new ObjectName(MBEAN_NAME_PREFIX + sample.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected NodeLog getNodeLog(EventObject event) {
        ProcessLogEvent e = (ProcessLogEvent)event;
        return (NodeLog)e.getLog();
    }

    protected boolean handleEvent(EventObject event) {
        if (!(event instanceof ProcessLogEvent)) {
            return false;
        }
        ProcessLogEvent e = (ProcessLogEvent)ProcessLogEvent.class.cast(event);
        return e.getLog() instanceof NodeLog;
    }
}

