/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.core;

import com.tandbergtv.workflow.monitor.core.ISample;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MetricSample
implements ISample {
    private String name;
    private AtomicLong total;
    private AtomicInteger count;

    public MetricSample(String name) {
        this.name = name;
        this.count = new AtomicInteger(0);
        this.total = new AtomicLong(0L);
    }

    public String getName() {
        return this.name;
    }

    public void add(long delta) {
        this.count.incrementAndGet();
        this.total.getAndAdd(delta);
    }

    @Override
    public long getTotal() {
        return this.total.get();
    }

    @Override
    public double getAverage() {
        if (this.count.get() == 0) {
            return 0.0;
        }
        return this.total.doubleValue() / (double)this.count.intValue();
    }

    @Override
    public long getMinimum() {
        return Long.MIN_VALUE;
    }

    @Override
    public long getMaximum() {
        return Long.MAX_VALUE;
    }
}

