/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.monitor.core.IObserver;
import com.tandbergtv.workflow.monitor.core.Metric;
import com.tandbergtv.workflow.monitor.core.Recorder;
import com.tandbergtv.workflow.monitor.internal.FileRecorderProperties;
import com.tandbergtv.workflow.monitor.internal.FileSystemArchiver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FileSystemRecorder
extends Recorder {
    private File root;
    private static final long CLEANUP_PERIOD = TimeUnit.MILLISECONDS.convert(6L, TimeUnit.HOURS);
    private static final long EXPIRE_PERIOD = TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS);
    private static final Logger logger = Logger.getLogger(FileSystemRecorder.class);

    public FileSystemRecorder(ISchedulerService<Void> pool, String name, File root) {
        super(pool, name);
        this.root = root;
    }

    public File getRoot() {
        return this.root;
    }

    @Override
    public void record() {
        for (IObserver observer : this.observers) {
            List<Metric> metrics = observer.getMetrics();
            for (Metric metric : metrics) {
                File file = FileRecorderProperties.getFile(FileRecorderProperties.directoryFor(this.root, metric), metric);
                logger.debug((Object)("File " + file.getAbsolutePath()));
                this.update(file, metric);
            }
        }
    }

    @Override
    public void start() {
        super.start();
        this.pool.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    FileSystemArchiver archiver = new FileSystemArchiver(FileSystemRecorder.this.root, EXPIRE_PERIOD);
                    for (IObserver observer : FileSystemRecorder.this.observers) {
                        archiver.archive(observer.getMetricNames());
                    }
                }
                catch (Throwable t) {
                    Logger.getLogger(FileSystemRecorder.class).warn((Object)t.getMessage());
                }
            }
        }, 0L, CLEANUP_PERIOD);
    }

    private void update(File file, Metric metric) {
        block12: {
            Writer out = null;
            try {
                try {
                    String time = String.valueOf(metric.getTime());
                    String value = metric.getValue().toString();
                    FileOutputStream os = new FileOutputStream(file, true);
                    out = new OutputStreamWriter((OutputStream)os, "UTF-8");
                    out.append(metric.getName()).append('\t').append(time).append('\t').append(value);
                    out.append(System.getProperty("line.separator"));
                }
                catch (IOException e) {
                    logger.warn((Object)("Cannot update " + file), (Throwable)e);
                    if (out == null) break block12;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

