/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.core;

import com.tandbergtv.workflow.monitor.core.ISample;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MetricSample
implements ISample {
    private String name;
    private AtomicLong total;
    private AtomicInteger count;
    private double ewma;
    private double alpha = 0.3;

    public MetricSample(String name) {
        this.name = name;
        this.count = new AtomicInteger(0);
        this.total = new AtomicLong(0L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void add(long delta) {
        this.count.incrementAndGet();
        this.total.getAndAdd(delta);
        double ma = this.count.get() == 1 ? (double)delta : this.ewma * (1.0 - this.alpha) + this.alpha * (double)delta;
        this.ewma = ma > 1.0E-4 ? ma : 0.0;
    }

    @Override
    public long getTotal() {
        return this.total.longValue();
    }

    @Override
    public long getCount() {
        return this.count.longValue();
    }

    @Override
    public double getAverage() {
        if (this.count.get() == 0) {
            return 0.0;
        }
        return this.total.doubleValue() / (double)this.count.intValue();
    }

    @Override
    public double getEWMA() {
        return this.ewma;
    }

    @Override
    public double get95thPercentile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double get99thPercentile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMinimum() {
        return Long.MIN_VALUE;
    }

    @Override
    public long getMaximum() {
        return Long.MAX_VALUE;
    }
}

