/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AlarmNotificationService
implements IAlarmNotificationService {
    private Set<IAlarmNotificationProvider> providers = new HashSet<IAlarmNotificationProvider>();

    @Override
    public List<AlarmNotification> getAlarms(long timestamp) {
        ArrayList<AlarmNotification> alarms = new ArrayList<AlarmNotification>();
        for (IAlarmNotificationProvider provider : this.providers) {
            alarms.addAll(provider.getAlarms(timestamp));
        }
        return alarms;
    }

    @Override
    public void addProvider(IAlarmNotificationProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public void removeProvider(IAlarmNotificationProvider provider) {
        this.providers.remove(provider);
    }

    public void start() {
    }

    public void stop() {
        this.providers.clear();
    }

    public String getServiceName() {
        return "alarm-notifications";
    }
}

