/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor.internal;

import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationProvider;
import com.tandbergtv.workflow.monitor.core.alarm.IAlarmNotificationService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AlarmNotificationService
implements IAlarmNotificationService {
    private static final Logger logger = Logger.getLogger(AlarmNotificationService.class);
    private Set<IAlarmNotificationProvider> providers;
    private Map<String, Long> totalTimeTaken = new HashMap<String, Long>();
    private Map<String, Long> callCounters = new HashMap<String, Long>();

    public AlarmNotificationService() {
        this.providers = new HashSet<IAlarmNotificationProvider>();
    }

    @Override
    public List<AlarmNotification> getAlarms(long timestamp) {
        Calendar dateCutoff = Calendar.getInstance();
        dateCutoff.setTimeInMillis(timestamp);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Getting alarms for date cutoff: " + dateCutoff.getTime()));
        }
        ArrayList<AlarmNotification> alarms = new ArrayList<AlarmNotification>();
        for (IAlarmNotificationProvider provider : this.providers) {
            long start = System.currentTimeMillis();
            alarms.addAll(provider.getAlarms(dateCutoff));
            long end = System.currentTimeMillis();
            if (!logger.isDebugEnabled()) continue;
            String providerName = provider.getClass().getSimpleName();
            Long diff = end - start;
            logger.debug((Object)(String.valueOf(provider.getClass().getSimpleName()) + ": " + diff + " millis"));
            this.aggregateCallTime(providerName, diff);
        }
        if (logger.isDebugEnabled()) {
            this.getAverageCallTime();
        }
        return alarms;
    }

    @Override
    public void addProvider(IAlarmNotificationProvider provider) {
        this.providers.add(provider);
        this.callCounters.put(provider.getClass().getSimpleName(), 0L);
        this.totalTimeTaken.put(provider.getClass().getSimpleName(), 0L);
    }

    @Override
    public void removeProvider(IAlarmNotificationProvider provider) {
        this.providers.remove(provider);
        this.callCounters.remove(provider.getClass().getSimpleName());
        this.totalTimeTaken.remove(provider.getClass().getSimpleName());
    }

    public void start() {
    }

    public void stop() {
        this.providers.clear();
        this.callCounters.clear();
        this.totalTimeTaken.clear();
    }

    public String getServiceName() {
        return "alarm-notifications";
    }

    private void aggregateCallTime(String providerName, Long diff) {
        Long totalTime = this.totalTimeTaken.get(providerName);
        totalTime = totalTime + diff;
        this.totalTimeTaken.put(providerName, totalTime);
        Long callCounter = this.callCounters.get(providerName);
        callCounter = callCounter + 1L;
        this.callCounters.put(providerName, callCounter);
    }

    private void getAverageCallTime() {
        for (IAlarmNotificationProvider provider : this.providers) {
            String providerName = provider.getClass().getSimpleName();
            Long totalTime = this.totalTimeTaken.get(providerName);
            Long callCounter = this.callCounters.get(providerName);
            logger.debug((Object)(String.valueOf(provider.getClass().getSimpleName()) + ": " + totalTime / callCounter + " millis"));
        }
    }
}

