/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.PartitionEvent;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.event.TaskCreatedEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.event.message.TaskCompleteEvent;
import com.tandbergtv.workflow.driver.event.message.TaskUpdateEvent;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class EventHandler
implements IColleague {
    private static final Logger logger = Logger.getLogger(EventHandler.class);

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        block34: {
            block35: {
                Object source = event.getSource();
                if (source == this) {
                    return;
                }
                IProcessCounter counter = (IProcessCounter)((Object)this.getProcessManagerService().getStatistics().getCumulativeStatistics());
                if (!(event instanceof WorkflowProcessEvent)) break block35;
                WorkflowProcessEvent e = (WorkflowProcessEvent)event;
                CustomToken token = (CustomToken)e.getToken();
                WorkflowProcess process = token.getProcessInstance();
                logger.debug((Object)(token + ", event " + e.getType()));
                if (e.getType() != WorkflowProcessEventType.CREATED) {
                    this.check(process, (WorkflowEvent)e);
                }
                switch (e.getType()) {
                    case STARTED: 
                    case DEQUEUED: 
                    case RESUMED: 
                    case ACQUIRED: 
                    case RELEASED: 
                    case JOINED: {
                        this.save(process);
                        break;
                    }
                    case BRANCHED: {
                        counter.branched(token);
                        this.persist(process);
                        break;
                    }
                    case DELETED: {
                        this.persist(process);
                        break;
                    }
                    case QUEUED: {
                        counter.enqueued(token);
                        this.updateProgress(token, "100");
                        this.save(process);
                        break;
                    }
                    case STOPPED: {
                        counter.completed(token);
                        if (token.isRoot()) {
                            this.persist(process);
                            break;
                        }
                        this.save(process);
                        break;
                    }
                    case PAUSING: 
                    case CANCELLING: {
                        if (token.isRoot()) {
                            this.save(process);
                            break;
                        }
                        break block34;
                    }
                    case PAUSED: {
                        this.deleteTimer(token);
                        this.save(process);
                        break;
                    }
                    case CANCELLED: {
                        this.deleteTimer(token);
                        this.persist(process);
                        break;
                    }
                    case FAILED: {
                        counter.failed(token);
                        this.deleteTimer(token);
                        this.save(process);
                        try {
                            if (token.isResumeAfterFail()) {
                                logger.debug((Object)(token + " indicates that it wants to be retried"));
                                token.setResumeAfterFail(false);
                                this.getProcessManagerService().resume(token);
                            }
                            break block34;
                        }
                        catch (DriverException t) {
                            logger.warn((Object)(process + " failed to resume"), (Throwable)t);
                        }
                        break block34;
                    }
                    case CRASHED: {
                        this.save(process);
                    }
                }
                break block34;
            }
            if (event instanceof TaskUpdateEvent) {
                TaskUpdateEvent e = (TaskUpdateEvent)event;
                CustomToken token = (CustomToken)e.getToken();
                this.check(token.getProcessInstance(), event);
                if (token.getStatus() == ProcessStatus.BUSY || token.getStatus() == ProcessStatus.RUNNING) {
                    String percent = e.getPercentComplete();
                    String name = token.getNode().getName();
                    logger.info((Object)(token + " (" + name + ") " + percent + "% complete"));
                    this.updateProgress(token, percent);
                    this.cache(token.getProcessInstance());
                }
            } else if (event instanceof TaskCreatedEvent) {
                TaskCreatedEvent e = (TaskCreatedEvent)event;
                WorkflowProcess process = e.getProcess();
                this.check(process, event);
                this.persist(process);
            } else if (event instanceof TaskCompleteEvent) {
                TaskCompleteEvent e = (TaskCompleteEvent)event;
                CustomToken token = (CustomToken)e.getToken();
                String name = token.getNode().getName();
                this.check(token.getProcessInstance(), event);
                if (token.getStatus() == ProcessStatus.QUEUED && e.hasFailed()) {
                    logger.info((Object)(token + " has failed at (" + name + ")"));
                    token.fail(ErrorCategory.NACK, "Received NACK");
                } else {
                    logger.info((Object)(token + " (" + name + ") completed"));
                }
            } else if (event instanceof PartitionEvent) {
                ICacheService<WorkflowProcess> cache = this.getCache();
                if (cache != event.getSource()) {
                    return;
                }
                PartitionEvent e = (PartitionEvent)PartitionEvent.class.cast(event);
                if (!e.isCompleted() || e.isSourceAlive()) {
                    return;
                }
                logger.debug((Object)("Partitioning event for " + e.getKeys().size() + " processes: " + e.getEvent()));
                IProcessManagerService service = this.getProcessManagerService();
                HashSet pending = new HashSet();
                for (Serializable key : e.getKeys()) {
                    WorkflowProcess process = (WorkflowProcess)cache.get(key);
                    if (process == null) continue;
                    if (ProcessFinder.hasOwner(process)) {
                        logger.info((Object)(process.getRootToken() + " is running, no need to recover"));
                        continue;
                    }
                    service.recover(process.getRootToken());
                }
                for (WorkflowProcess process : pending) {
                    service.recover(process.getRootToken());
                }
            }
        }
    }

    private void check(WorkflowProcess process, WorkflowEvent event) {
        if (!ProcessFinder.isOwner(process)) {
            logger.warn((Object)(process.getRootToken() + ", received event " + event));
        }
    }

    private IProcessManagerService getProcessManagerService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    private void save(WorkflowProcess process) {
        ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).save(process);
    }

    private void persist(WorkflowProcess process) {
        ((IPersistenceService)ServiceRegistry.getDefault().lookup(IPersistenceService.class)).persist(process);
    }

    private ICacheService<WorkflowProcess> getCache() {
        return (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    private void cache(WorkflowProcess process) {
        this.getCache().add((Serializable)Long.valueOf(process.getId()), (Object)process);
        logger.debug((Object)(process.getRootToken() + ", added to cache"));
    }

    private void deleteTimer(CustomToken token) {
        ITimerService service = this.getTimerService();
        if (service != null) {
            service.deleteTimer((Token)token);
        }
    }

    private void updateProgress(CustomToken token, String percent) {
        IProgressTrackingStrategy tracker = (IProgressTrackingStrategy)ServiceRegistry.getDefault().lookup(IProgressTrackingStrategy.class);
        if (tracker == null) {
            return;
        }
        if (percent.equals("100")) {
            tracker.setComplete(token);
        } else {
            tracker.setPercentComplete(token, percent);
        }
    }

    private ITimerService getTimerService() {
        return (ITimerService)ServiceRegistry.getDefault().lookup(ITimerService.class);
    }
}

