/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.ProcessStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WFToken {
    private long tokenId;
    private long processId;
    private int operationalStatus;
    private int administrativeStatus;
    private String nodeName;
    private Date startTime;
    private Date endTime;
    private List<WFToken> children = new ArrayList<WFToken>();
    private Date errorTime;
    private String errorComment;

    public WFToken getChildWithId(long id) {
        WFToken retVal = null;
        if (this.tokenId == id) {
            retVal = this;
        } else {
            for (WFToken child : this.children) {
                retVal = child.getChildWithId(id);
                if (retVal != null) break;
            }
        }
        return retVal;
    }

    public List<WFToken> getAllChildren() {
        ArrayList<WFToken> returnVal = new ArrayList<WFToken>();
        returnVal.addAll(this.children);
        for (WFToken child : this.children) {
            returnVal.addAll(child.getAllChildren());
        }
        return returnVal;
    }

    public List<WFToken> getChildren() {
        return this.children;
    }

    public void addChild(WFToken child) {
        if (child == null) {
            return;
        }
        this.children.add(child);
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(long tokenId) {
        this.tokenId = tokenId;
    }

    public int getOperationalStatus() {
        return this.operationalStatus;
    }

    public String getOperationalStatusStr() {
        return ProcessStatus.values()[this.operationalStatus].name();
    }

    public void setOperationalStatus(int operationalStatus) {
        this.operationalStatus = operationalStatus;
    }

    public int getAdministrativeStatus() {
        return this.administrativeStatus;
    }

    public String getAdministrativeStatusStr() {
        return ProcessStatus.values()[this.administrativeStatus].name();
    }

    public void setAdministrativeStatus(int administrativeStatus) {
        this.administrativeStatus = administrativeStatus;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }

    public String getErrorComment() {
        return this.errorComment;
    }

    public void setErrorComment(String errorComment) {
        this.errorComment = errorComment;
    }

    public Date getErrorTime() {
        return this.errorTime;
    }

    public void setErrorTime(Date errorTime) {
        this.errorTime = errorTime;
    }
}

