/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.resource;

import com.tandbergtv.workflow.core.service.thread.DistributedCallable;
import com.tandbergtv.workflow.resourcemanager.IResourceService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceTypeIdAware;
import com.tandbergtv.workflow.resourcemanager.internal.callable.ResourceManagementCallable;

public abstract class ResourceServiceCallable<V>
extends ResourceManagementCallable<V>
implements DistributedCallable<V> {
    private static final long serialVersionUID = -9134823319078274388L;
    private Long resourceTypeId;

    protected ResourceServiceCallable() {
    }

    protected ResourceServiceCallable(Long resourceTypeId) {
        this.resourceTypeId = resourceTypeId;
    }

    public Long getKey() {
        return this.getResourceTypeId();
    }

    public Long getResourceTypeId() {
        return this.resourceTypeId;
    }

    @Override
    protected V performTask() throws Exception {
        IResourceTypeIdAware service = null;
        if (IResourceTypeIdAware.class.isInstance(this.getService())) {
            service = (IResourceTypeIdAware)IResourceTypeIdAware.class.cast(this.getService());
        }
        if (service != null) {
            service.setResourceTypeIdForRequest(this.getResourceTypeId());
        }
        try {
            V v = this.performServiceTask();
            return v;
        }
        finally {
            if (service != null) {
                service.removeResourceTypeIdForRequest();
            }
        }
    }

    protected abstract V performServiceTask() throws Exception;

    protected IResourceService getService() {
        return (IResourceService)this.getService("LocalResourceService");
    }
}

