/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.mgmt.allocation;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.IAllocationKeyService;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.AllocationUtility;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.DefaultResourceAllocationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.allocation.IKeyBasedAllocationStrategy;

public class DefaultKeyBasedAllocationStrategy
extends DefaultResourceAllocationStrategy
implements IKeyBasedAllocationStrategy {
    @Override
    public Resource allocateResource(ResourceGroup resourceGroup, String allocationKey) {
        if (allocationKey == null || allocationKey.trim().length() == 0) {
            return this.allocateResource(resourceGroup);
        }
        Resource resource = this.getMatchingResource(resourceGroup, allocationKey);
        if (resource == null) {
            String msg = "ResourceGroup[id=" + resourceGroup.getId() + "] does not contain " + "a resource with a connection string that matches allocation key: " + allocationKey + ".";
            throw new RuntimeException(msg);
        }
        if (!AllocationUtility.isResourceAvailable(resource)) {
            resource = null;
        }
        return resource;
    }

    private Resource getMatchingResource(ResourceGroup resourceGroup, String allocationKey) {
        Resource match = null;
        ResourceManagement rm = (ResourceManagement)ServiceRegistry.getDefault().lookup(ResourceManagement.class);
        IAllocationKeyService service = rm.getAllocationKeyService();
        for (Resource resource : resourceGroup.getResources()) {
            if (!service.isMatch(resource, allocationKey)) continue;
            match = resource;
            break;
        }
        return match;
    }
}

