/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.event;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceConsumerKey;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.event.IResourceConsumerAware;
import com.tandbergtv.workflow.resourcemanager.event.ResourceManagementEvent;

public class ResourceFailedEvent
extends ResourceManagementEvent
implements IResourceConsumerAware {
    private static final long serialVersionUID = 3793767724467144568L;
    private long resourceId;
    private ResourceConsumerKey key;
    private boolean heartbeatFailure;

    public ResourceFailedEvent(ResourceConsumerKey key, Resource resource) {
        this.key = key;
        this.resourceId = resource.getId();
        this.heartbeatFailure = resource.getOperationalState() == ResourceState.HEARTBEAT_ERROR;
    }

    public ResourceFailedEvent(CustomToken token, Resource resource) {
        WorkflowProcess process = token.getProcessInstance();
        this.key = new ResourceConsumerKey(token.getId(), process.getId(), -1L, null, process.getPriority());
        this.resourceId = resource.getId();
        this.heartbeatFailure = resource.getOperationalState() == ResourceState.HEARTBEAT_ERROR;
    }

    @Override
    public ResourceConsumerKey getResourceConsumerKey() {
        return this.key;
    }

    public long getResourceId() {
        return this.resourceId;
    }

    public boolean isHeartBeatFailure() {
        return this.heartbeatFailure;
    }
}

