/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.pluginmanager.internal;

import com.tandbergtv.workflow.pluginmanager.entities.FailureDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceGroupDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.pluginmanager.entities.WatchPointDescriptor;
import com.tandbergtv.workflow.pluginmanager.internal.WatchPointPluginClassLoader;
import com.tandbergtv.workflow.pluginmanager.util.ExtensionParser;
import com.tandbergtv.workflow.pluginmanager.util.ResourceGroupExtensionParser;
import com.tandbergtv.workflow.pluginmanager.util.ResourceGroupPluginValidator;
import com.tandbergtv.workflow.pluginmanager.util.ResourceTypeDescriptorValidator;
import com.tandbergtv.workflow.pluginmanager.util.ResourceTypeExtensionValidator;
import java.util.ArrayList;
import java.util.List;
import org.java.plugin.PathResolver;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class PluginExtensionHandler {
    public static final String WATCHPOINT_PLUGIN_ID = "com.tandbergtv.workflow";
    public static final String RESOURCE_TYPE_EXTENSION_POINT_ID = "resourcetype";
    public static final String RESOURCE_GROUP_EXTENSION_POINT_ID = "resourcegroup";

    public IntegrityCheckReport getReport(PluginManager pluginManager) {
        PluginRegistry registry = pluginManager.getRegistry();
        PathResolver pathResolver = pluginManager.getPathResolver();
        return registry.checkIntegrity(pathResolver, true);
    }

    public WatchPointDescriptor buildDescriptor(PluginManager manager, Extension extension, IntegrityCheckReport report) {
        FailureDescriptor failedDescriptor = this.validateExtension(extension, report);
        if (failedDescriptor != null) {
            return failedDescriptor;
        }
        WatchPointDescriptor descriptor = this.parseExtension(manager, extension);
        failedDescriptor = this.validateDescriptor(descriptor);
        if (failedDescriptor != null) {
            return failedDescriptor;
        }
        return descriptor;
    }

    public FailureDescriptor buildDescriptorForDuplicateKey(WatchPointDescriptor descriptor) {
        if (descriptor instanceof ResourceTypeDescriptor) {
            ResourceTypeDescriptor type = (ResourceTypeDescriptor)descriptor;
            return this.prepareFailureDescriptor(type);
        }
        if (descriptor instanceof ResourceGroupDescriptor) {
            ResourceGroupDescriptor group = (ResourceGroupDescriptor)descriptor;
            return ResourceGroupPluginValidator.createDuplicateKeyFailureDescriptor(group);
        }
        return null;
    }

    public boolean isResourceTypeExtension(Extension extension) {
        return this.isMatchingExtension(extension, RESOURCE_TYPE_EXTENSION_POINT_ID);
    }

    public boolean isResourceGroupExtension(Extension extension) {
        return this.isMatchingExtension(extension, RESOURCE_GROUP_EXTENSION_POINT_ID);
    }

    private boolean isMatchingExtension(Extension extension, String extensionPointId) {
        String extendedPointId = extension.getExtendedPointId();
        String pluginId = extension.getExtendedPluginId();
        return pluginId.equals(WATCHPOINT_PLUGIN_ID) && extendedPointId.equals(extensionPointId);
    }

    private FailureDescriptor validateExtension(Extension extension, IntegrityCheckReport report) {
        if (this.isResourceTypeExtension(extension)) {
            List<String> messages = ResourceTypeExtensionValidator.validate(extension, report);
            return this.prepareFailureDescriptor(extension, messages);
        }
        if (this.isResourceGroupExtension(extension)) {
            return ResourceGroupPluginValidator.validateExtension(extension, report);
        }
        return null;
    }

    private FailureDescriptor prepareFailureDescriptor(Extension extension, List<String> messages) {
        FailureDescriptor result = null;
        if (messages.size() > 0) {
            result = new FailureDescriptor();
            result.setPluginId(extension.getDeclaringPluginDescriptor().getId());
            result.setExtensionId(extension.getId());
            Extension.Parameter param = extension.getParameter("systemId");
            if (param != null) {
                result.setId(param.valueAsString());
            }
            if ((param = extension.getParameter("name")) != null) {
                result.setName(param.valueAsString());
            }
            result.setSummaryMessage("The Plugin Extension has failed basic validation.");
            result.setErrorMessages(messages);
        }
        return result;
    }

    private FailureDescriptor prepareFailureDescriptor(ResourceTypeDescriptor descriptor) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("The System Id specified is already used by another Resource Type.");
        FailureDescriptor result = new FailureDescriptor();
        result.setPluginId(descriptor.getPluginId());
        result.setExtensionId(descriptor.getExtensionId());
        result.setId(descriptor.getSystemId());
        result.setName(descriptor.getName());
        result.setCreateDate(descriptor.getCreateDate());
        result.setSummaryMessage("The Plugin Extension has failed basic validation.");
        result.setErrorMessages(messages);
        return result;
    }

    private WatchPointDescriptor parseExtension(PluginManager manager, Extension extension) {
        PluginDescriptor plugin = extension.getDeclaringPluginDescriptor();
        WatchPointPluginClassLoader loader = new WatchPointPluginClassLoader(manager.getPluginClassLoader(plugin));
        if (this.isResourceTypeExtension(extension)) {
            return ExtensionParser.parseResourceTypeExtension(extension, (ClassLoader)((Object)loader));
        }
        if (this.isResourceGroupExtension(extension)) {
            return ResourceGroupExtensionParser.parse(extension, (ClassLoader)((Object)loader));
        }
        return null;
    }

    private FailureDescriptor validateDescriptor(WatchPointDescriptor descriptor) {
        if (descriptor instanceof ResourceTypeDescriptor) {
            return this.validateResourceTypeDescriptor((ResourceTypeDescriptor)descriptor);
        }
        if (descriptor instanceof ResourceGroupDescriptor) {
            return this.validateResourceGroupDescriptor((ResourceGroupDescriptor)descriptor);
        }
        return null;
    }

    private FailureDescriptor validateResourceTypeDescriptor(ResourceTypeDescriptor descriptor) {
        FailureDescriptor result = null;
        List<String> messages = ResourceTypeDescriptorValidator.validate(descriptor);
        if (messages.size() > 0) {
            result = new FailureDescriptor();
            result.setPluginId(descriptor.getPluginId());
            result.setExtensionId(descriptor.getExtensionId());
            result.setId(descriptor.getSystemId());
            result.setCreateDate(descriptor.getCreateDate());
            result.setName(descriptor.getName());
            result.setSummaryMessage("Plugin Extension was successfully loaded, but failed validation.");
            result.setErrorMessages(messages);
        }
        return result;
    }

    private FailureDescriptor validateResourceGroupDescriptor(ResourceGroupDescriptor descriptor) {
        return ResourceGroupPluginValidator.validateDescriptor(descriptor, false);
    }
}

