/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.resourcetype;

import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.resourcemanager.FinderException;
import com.tandbergtv.workflow.resourcemanager.IResourceTypeService;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.internal.IDistributedServiceTaskExecutor;
import com.tandbergtv.workflow.resourcemanager.internal.ILocatorService;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.ResourceManagementService;
import com.tandbergtv.workflow.resourcemanager.internal.resourcetype.GetAllResourceTypesCallable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DistributedResourceTypeService
extends ResourceManagementService
implements IResourceTypeService,
IResourceManagementService {
    @Override
    public List<ResourceType> getAllResourceTypes() {
        ArrayList<ResourceType> list = new ArrayList<ResourceType>();
        GetAllResourceTypesCallable callable = new GetAllResourceTypesCallable();
        String failureMessage = "Failed to get all resource types";
        Collection<List<ResourceType>> results = this.getDistributedExecutor().runMultiTask(callable, failureMessage);
        if (results != null) {
            for (List<ResourceType> result : results) {
                if (result == null) continue;
                list.addAll(result);
            }
        }
        return list;
    }

    @Override
    public ResourceType getResourceType(long resourceTypeId) throws FinderException {
        ResourceType result = (ResourceType)this.getResourceTypeCache().get((Serializable)Long.valueOf(resourceTypeId));
        if (result == null) {
            String msg = "Could not find Resource Type with Id: " + resourceTypeId;
            throw new FinderException(msg);
        }
        return result;
    }

    @Override
    public ResourceType getResourceTypeBySystemId(String systemId) {
        Long resourceTypeId = this.getLocatorService().getResourceTypeIdForDevice(systemId);
        return resourceTypeId != null ? (ResourceType)this.getResourceTypeCache().get((Serializable)resourceTypeId) : null;
    }

    @Override
    public String getServiceName() {
        return "DistributedResourceTypeService";
    }

    private IDistributedServiceTaskExecutor getDistributedExecutor() {
        return this.getService(IDistributedServiceTaskExecutor.class);
    }

    private IDistributedCache<ResourceType> getResourceTypeCache() {
        return (IDistributedCache)this.getService("WFS:ResourceTypeCache");
    }

    private ILocatorService getLocatorService() {
        return this.getService(ILocatorService.class);
    }
}

