/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager;

import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IMultiValueCacheService;
import com.tandbergtv.workflow.pluginmanager.PluginManagement;
import com.tandbergtv.workflow.pluginmanager.entities.ResourceTypeDescriptor;
import com.tandbergtv.workflow.resourcemanager.ResourceGroupContainer;
import com.tandbergtv.workflow.resourcemanager.ResourceStateManager;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceDAI;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.internal.ICloneService;
import com.tandbergtv.workflow.resourcemanager.internal.IHibernatePersistenceService;
import com.tandbergtv.workflow.resourcemanager.internal.container.BaseContainer;
import com.tandbergtv.workflow.resourcemanager.internal.event.IEventHandler;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.HeartBeatListener;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.HeartBeatStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.heartbeat.ResourceHeartBeatEvent;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.InitializationListener;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.InitializationStrategy;
import com.tandbergtv.workflow.resourcemanager.mgmt.initialization.ResourceInitializationEvent;
import com.tandbergtv.workflow.resourcemanager.util.StrategyClassLoadException;
import com.tandbergtv.workflow.resourcemanager.util.StrategyClassLoader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class ResourceContainer
extends BaseContainer<Resource> {
    private static final long serialVersionUID = 1749133216952823784L;
    private static Logger logger = Logger.getLogger(ResourceContainer.class);
    private HeartBeatStrategy heartbeatStrategy;
    private InitializationStrategy initializationStrategy;
    private final List<Long> groupIdsForNotification = new ArrayList<Long>();

    public ResourceContainer(Resource resource) {
        super(resource);
    }

    private void initializeStrategies(ResourceTypeDescriptor descriptor) {
        String msg;
        String hbStrategyClass = null;
        Map<String, String> heartbeatProperties = null;
        String initStrategyClass = null;
        Map<String, String> initProperties = null;
        ClassLoader loader = null;
        if (descriptor != null) {
            hbStrategyClass = descriptor.getManagement().getHeartbeatStrategyClass();
            heartbeatProperties = descriptor.getManagement().getHeartbeatProperties();
            initStrategyClass = descriptor.getManagement().getInitializationStrategyClass();
            initProperties = descriptor.getManagement().getInitializationProperties();
            loader = descriptor.getClassLoader();
        }
        try {
            if (hbStrategyClass != null) {
                this.heartbeatStrategy = StrategyClassLoader.loadHeartBeatStrategy(hbStrategyClass, loader);
                this.heartbeatStrategy.setConfiguration(heartbeatProperties);
            } else {
                this.heartbeatStrategy = StrategyClassLoader.createDefaultHeartBeatStrategy();
            }
        }
        catch (StrategyClassLoadException scle) {
            msg = "Failed to load the HeartBeat Strategy, using the Default Strategy instead.";
            logger.error((Object)msg, (Throwable)scle);
            this.heartbeatStrategy = StrategyClassLoader.createDefaultHeartBeatStrategy();
        }
        try {
            if (initStrategyClass != null) {
                this.initializationStrategy = StrategyClassLoader.loadInitializationStrategy(initStrategyClass, loader);
                this.initializationStrategy.setConfiguration(initProperties);
            } else {
                this.initializationStrategy = StrategyClassLoader.createDefaultInitializationStrategy();
            }
        }
        catch (StrategyClassLoadException scle) {
            msg = "Failed to load the Initialization Strategy, using the Default Strategy instead.";
            logger.error((Object)msg, (Throwable)scle);
            this.initializationStrategy = StrategyClassLoader.createDefaultInitializationStrategy();
        }
        if (this.heartbeatStrategy != null) {
            this.heartbeatStrategy.setResource(this.getCloneService().cloneResource((Resource)this.getEntity()));
            this.heartbeatStrategy.addHeartBeatListener(new ResourceHeartBeatListener());
        }
        if (this.initializationStrategy != null) {
            this.initializationStrategy.setResource(this.getCloneService().cloneResource((Resource)this.getEntity()));
            this.initializationStrategy.addInitializationListener(new ResourceInitializationListener());
        }
    }

    Resource getResource() {
        return (Resource)this.getEntity();
    }

    HeartBeatStrategy getHeartBeatStrategy() {
        return this.heartbeatStrategy;
    }

    InitializationStrategy getInitializationStrategy() {
        return this.initializationStrategy;
    }

    public String toString() {
        return "resource" + ((Resource)this.getEntity()).toString();
    }

    private void handleEvent(WorkflowEvent event) {
        IEventHandler handler = (IEventHandler)this.getService("ResourceManagementDistributedEventHandler");
        handler.handleEvent(event);
    }

    private ICloneService getCloneService() {
        return (ICloneService)this.getRegistry().lookup(ICloneService.class);
    }

    @Override
    public void initialize() {
        String systemId = ((Resource)this.getEntity()).getResourceType().getSystemId();
        PluginManagement manager = (PluginManagement)ServiceRegistry.getDefault().lookup(PluginManagement.class);
        ResourceTypeDescriptor descriptor = manager.getResourceTypeDescriptor(systemId);
        this.initializeStrategies(descriptor);
    }

    @Override
    protected void doStart() {
        ResourceStateManager stateManager = this.getService(ResourceStateManager.class);
        switch (((Resource)this.getEntity()).getOperationalState()) {
            case OFFLINE: {
                if (!stateManager.initializeResource(this)) break;
                this.updateEntity(true);
                break;
            }
            case INITIALIZING: {
                InitializationStrategy strategy = this.getInitializationStrategy();
                if (strategy == null || strategy.isInitializing()) break;
                try {
                    strategy.initializeResource();
                }
                catch (RuntimeException e) {
                    logger.warn((Object)("Failure starting initialization for resource " + this.getEntity()), (Throwable)e);
                }
                break;
            }
            case ONLINE: 
            case HEARTBEAT_ERROR: 
            case ERROR: {
                HeartBeatStrategy strategy = this.getHeartBeatStrategy();
                if (strategy == null || strategy.isMonitoringHeartBeats()) break;
                try {
                    strategy.startHeartBeatMonitor();
                }
                catch (RuntimeException e) {
                    logger.warn((Object)("Failure starting heart beats for resource " + this.getEntity()), (Throwable)e);
                }
                break;
            }
        }
    }

    @Override
    protected void doStop() {
        if (this.getInitializationStrategy() != null && this.getInitializationStrategy().isInitializing()) {
            try {
                this.getInitializationStrategy().stopInitializingResource();
            }
            catch (RuntimeException e) {
                logger.warn((Object)("Failure stopping initialization for resource " + this.getEntity()), (Throwable)e);
            }
        }
        if (this.getHeartBeatStrategy() != null && this.getHeartBeatStrategy().isMonitoringHeartBeats()) {
            try {
                this.getHeartBeatStrategy().stopHeartBeatMonitor();
            }
            catch (RuntimeException e) {
                logger.warn((Object)("Failure stopping heart beats for resource " + this.getEntity()), (Throwable)e);
            }
        }
    }

    @Override
    public void destroy() {
        this.initializationStrategy = null;
        this.heartbeatStrategy = null;
    }

    @Override
    public void setEntity(Resource entity) {
        super.setEntity(entity);
        ICloneService service = this.getCloneService();
        if (this.heartbeatStrategy != null) {
            this.heartbeatStrategy.setResource(service.cloneResource((Resource)this.getEntity()));
        }
        if (this.initializationStrategy != null) {
            this.initializationStrategy.setResource(service.cloneResource((Resource)this.getEntity()));
        }
    }

    @Override
    protected void writeToDistributedCache() {
        IMultiValueCacheService cache = (IMultiValueCacheService)this.getService("WFS:ResourceCache");
        cache.add((Serializable)this.getResourceTypeId(), (Object)this.getCloneService().cloneResource((Resource)this.getEntity()));
    }

    @Override
    protected void writeToPersistenceStore() {
        IHibernatePersistenceService service = this.getService(IHibernatePersistenceService.class);
        SessionFactory factory = service.getSessionFactory();
        Session session = factory.getCurrentSession();
        ResourceDAI dao = service.getDataAccessObjectFactory().getResourceDAO();
        ICloneService cloneService = this.getService(ICloneService.class);
        Resource clone = cloneService.cloneResource((Resource)this.getEntity(), false);
        service.beginTransaction((org.hibernate.Session)session);
        try {
            dao.update(clone);
            service.commitTransaction((org.hibernate.Session)session);
        }
        catch (RuntimeException ex) {
            service.rollbackTransaction((org.hibernate.Session)session);
            String msg = "Failed to internally update Resource[id=" + this.getKey() + "]: " + ((Resource)this.getEntity()).getName() + ", the object in memory is different from the DB.";
            logger.error((Object)msg, (Throwable)ex);
        }
    }

    @Override
    public Serializable getKey() {
        return Long.valueOf(((Resource)this.getEntity()).getId());
    }

    @Override
    public Long getResourceTypeId() {
        return ((Resource)this.getEntity()).getResourceType().getId();
    }

    public void performMaintenance(ResourceTypeDescriptor descriptor) {
        this.doStop();
        this.initializeStrategies(descriptor);
        this.doStart();
    }

    public void notifyResourceGroups() {
        this.updateResourceGroupsForNotification();
        ICacheService cache = (ICacheService)this.getService("ResourceGroupContainerCache");
        for (Long groupId : this.groupIdsForNotification) {
            ResourceGroupContainer container = (ResourceGroupContainer)cache.get((Serializable)groupId);
            if (container == null) continue;
            container.notifyQueue();
        }
    }

    public void updateResourceGroupsForNotification(long resourceGroupId) {
        this.updateResourceGroupsForNotification();
        if (this.groupIdsForNotification.contains(resourceGroupId)) {
            this.groupIdsForNotification.remove(resourceGroupId);
            this.groupIdsForNotification.add(resourceGroupId);
        }
    }

    private void updateResourceGroupsForNotification() {
        Iterator<Long> iterator = this.groupIdsForNotification.iterator();
        while (iterator.hasNext()) {
            Long groupId = iterator.next();
            if (((Resource)this.getEntity()).getResourceGroups().contains(new ResourceGroup(groupId))) continue;
            iterator.remove();
        }
        for (ResourceGroup group : ((Resource)this.getEntity()).getResourceGroups()) {
            if (this.groupIdsForNotification.contains(group.getId())) continue;
            this.groupIdsForNotification.add(group.getId());
        }
    }

    class ResourceHeartBeatListener
    implements HeartBeatListener {
        ResourceHeartBeatListener() {
        }

        @Override
        public void heartbeatSuccess(ResourceHeartBeatEvent event) {
            logger.debug((Object)("Received HeartBeat Success Event for Resource[" + ((Resource)ResourceContainer.this.getEntity()).getId() + "]: " + ((Resource)ResourceContainer.this.getEntity()).getName()));
            ResourceContainer.this.handleEvent(event);
        }

        @Override
        public void heartbeatFailure(ResourceHeartBeatEvent event) {
            String msg = "[Resource] Received HeartBeat Failure Event for Resource[" + ((Resource)ResourceContainer.this.getEntity()).getId() + "]: " + ((Resource)ResourceContainer.this.getEntity()).getName();
            if (event.getMessage() != null) {
                msg = String.valueOf(msg) + ": " + event.getMessage();
            }
            if (event.getError() != null) {
                logger.warn((Object)msg, event.getError());
            } else {
                logger.warn((Object)msg);
            }
            Throwable t = event.getError() == null ? new Throwable() : event.getError();
            ResourceHeartBeatEvent clone = new ResourceHeartBeatEvent(event.getSource(), (Resource)ResourceContainer.this.getEntity(), event.getMessage(), t);
            ResourceContainer.this.handleEvent(clone);
        }
    }

    class ResourceInitializationListener
    implements InitializationListener {
        ResourceInitializationListener() {
        }

        @Override
        public void initializationSuccess(ResourceInitializationEvent event) {
            logger.info((Object)("Received Initialization Success Event for Resource[" + ((Resource)ResourceContainer.this.getEntity()).getId() + "]: " + ((Resource)ResourceContainer.this.getEntity()).getName()));
            ResourceContainer.this.handleEvent(event);
        }

        @Override
        public void initializationFailure(ResourceInitializationEvent event) {
            String msg = "[Resource] Received Initialization Failure Event for Resource[" + ((Resource)ResourceContainer.this.getEntity()).getId() + "]: " + ((Resource)ResourceContainer.this.getEntity()).getName();
            if (event.getMessage() != null) {
                msg = String.valueOf(msg) + ": " + event.getMessage();
            }
            if (event.getError() != null) {
                logger.warn((Object)msg, event.getError());
            } else {
                logger.warn((Object)msg);
            }
            Throwable t = event.getError() == null ? new Throwable() : event.getError();
            ResourceInitializationEvent clone = new ResourceInitializationEvent(event.getSource(), (Resource)ResourceContainer.this.getEntity(), msg, t);
            ResourceContainer.this.handleEvent(clone);
        }
    }
}

