/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.entities;

import com.tandbergtv.workflow.resourcemanager.entities.ResourceEntity;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceState;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceType;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceUser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Resource
implements ResourceEntity {
    private static final long serialVersionUID = 4223466334114869896L;
    private long id = -1L;
    private String name;
    private String connectionString;
    private int maxConcurrentUsers = 0;
    private String heartbeatConnectionString;
    private Long heartbeatFrequency = null;
    private ResourceState administrationState = ResourceState.ONLINE;
    private ResourceState operationalState = ResourceState.OFFLINE;
    private Integer administrationStateId = new Integer(ResourceState.ONLINE.getId());
    private Integer operationalStateId = new Integer(ResourceState.OFFLINE.getId());
    private ResourceType resourceType;
    private boolean active = true;
    private transient Set<ResourceGroup> resourceGroups = new HashSet<ResourceGroup>();
    private transient List<ResourceGroup> orderedListOfResGroups = new ArrayList<ResourceGroup>();
    private String userName = null;
    private String functionalType;
    private Date createDate;
    private boolean ignoreTimeout = false;
    private Set<ResourceUser> users = new LinkedHashSet<ResourceUser>();
    private static final int HASHCODE_MULTIPLICATION_FACTOR = 7;
    private static final int HASHCODE_ADDITION_FACTOR = 458;

    public Resource() {
    }

    public Resource(long resourceId) {
        this.id = resourceId;
    }

    public Resource(Resource other) {
        this(other.id);
        this.name = other.name;
        this.setActive(other.active);
        this.setCreateDate(other.createDate);
        this.setAdministrationState(other.administrationState);
        this.setOperationalState(other.operationalState);
        this.setConnectionString(other.connectionString);
        this.setMaxConcurrentUsers(other.maxConcurrentUsers);
        this.setFunctionalType(other.functionalType);
        this.setHeartbeatConnectionString(other.heartbeatConnectionString);
        this.setHeartbeatFrequency(other.heartbeatFrequency);
        this.setUserName(other.userName);
        this.setResourceType(other.resourceType);
        for (ResourceGroup group : other.getResourceGroups()) {
            this.addResourceGroup(new ResourceGroup(group.getId()));
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public ResourceState getAdministrationState() {
        return this.administrationState;
    }

    public void setAdministrationState(ResourceState administrationState) {
        this.administrationState = administrationState;
        this.administrationStateId = administrationState != null ? new Integer(administrationState.getId()) : null;
    }

    Integer getAdministrationStateId() {
        return this.administrationStateId;
    }

    void setAdministrationStateId(Integer administrationStatusId) {
        this.setAdministrationState(ResourceState.getById(administrationStatusId));
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getFunctionalType() {
        return this.functionalType;
    }

    public void setFunctionalType(String functionalType) {
        this.functionalType = functionalType;
    }

    public String getHeartbeatConnectionString() {
        return this.heartbeatConnectionString;
    }

    public void setHeartbeatConnectionString(String heartbeatConnectionString) {
        this.heartbeatConnectionString = heartbeatConnectionString;
    }

    public Long getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public void setHeartbeatFrequency(Long heartbeatFrequency) {
        this.heartbeatFrequency = heartbeatFrequency;
    }

    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    public int getMaxConcurrentUsers() {
        return this.maxConcurrentUsers;
    }

    public void setMaxConcurrentUsers(int maxConcurrentUsers) {
        this.maxConcurrentUsers = maxConcurrentUsers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    @Deprecated
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public ResourceState getOperationalState() {
        return this.operationalState;
    }

    public void setOperationalState(ResourceState operationalState) {
        this.operationalState = operationalState;
        this.operationalStateId = operationalState != null ? new Integer(operationalState.getId()) : null;
    }

    Integer getOperationalStateId() {
        return this.operationalStateId;
    }

    void setOperationalStateId(Integer operationalStateId) {
        this.setOperationalState(ResourceState.getById(operationalStateId));
    }

    public boolean getIgnoreTimeout() {
        return this.ignoreTimeout;
    }

    public void setIgnoreTimeout(boolean ignoreTimeout) {
        this.ignoreTimeout = ignoreTimeout;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public Set<ResourceGroup> getResourceGroups() {
        return this.resourceGroups;
    }

    public void setResourceGroups(Set<ResourceGroup> groups) {
        this.resourceGroups = groups;
        this.orderedListOfResGroups = new ArrayList<ResourceGroup>(groups);
    }

    public void removeAllResourceGroups() {
        this.resourceGroups.clear();
        this.orderedListOfResGroups.clear();
    }

    public void addResourceGroup(ResourceGroup group) {
        if (group != null && !this.resourceGroups.contains(group)) {
            this.resourceGroups.add(group);
            this.orderedListOfResGroups.add(group);
        }
    }

    public void removeResourceGroup(ResourceGroup group) {
        this.resourceGroups.remove(group);
        this.orderedListOfResGroups.remove(group);
    }

    @Deprecated
    public List<ResourceGroup> getOrderedListOfResGroups() {
        return this.orderedListOfResGroups;
    }

    @Deprecated
    public void setOrderedListOfResGroups(List<ResourceGroup> orderedListOfResGroups) {
        this.orderedListOfResGroups = orderedListOfResGroups;
    }

    public Set<ResourceUser> getUsers() {
        return this.users;
    }

    @Deprecated
    public void setUsers(Set<ResourceUser> userList) {
        if (userList == this.users) {
            return;
        }
        this.users.clear();
        if (userList != null) {
            this.users.addAll(userList);
        }
    }

    public void addUser(ResourceUser user) {
        this.users.add(user);
    }

    public void removeUser(ResourceUser user) {
        this.users.remove(user);
    }

    public int getUserCount() {
        return this.users != null ? this.users.size() : 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Resource) {
            Resource resObj = (Resource)obj;
            if (resObj.getId() != -1L && this.getId() != -1L) {
                return resObj.getId() == this.getId();
            }
            return super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        long hash = this.id * 7L + 458L;
        int hashCode = new Long(hash).hashCode();
        if (this.id == -1L) {
            hashCode = super.hashCode();
        }
        return hashCode;
    }

    @Override
    public Resource clone() {
        Resource clone = null;
        try {
            clone = (Resource)super.clone();
            if (this.resourceType != null) {
                clone.resourceType = this.resourceType.clone();
            }
            if (this.resourceGroups != null) {
                clone.resourceGroups = new HashSet<ResourceGroup>(this.resourceGroups);
            }
            if (this.orderedListOfResGroups != null) {
                clone.orderedListOfResGroups = new ArrayList<ResourceGroup>(this.orderedListOfResGroups);
            }
            if (this.users != null) {
                clone.users = new LinkedHashSet<ResourceUser>();
                for (ResourceUser user : this.users) {
                    ResourceUser userClone = (ResourceUser)user.clone();
                    clone.addUser(userClone);
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String toString() {
        return "[" + this.id + "] " + this.name;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        TreeSet<ResourceGroup> sortedGroups = new TreeSet<ResourceGroup>(new ResourceGroupComparator());
        sortedGroups.addAll(this.resourceGroups);
        stream.writeObject(sortedGroups);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.resourceGroups = new HashSet<ResourceGroup>();
        this.orderedListOfResGroups = new ArrayList<ResourceGroup>();
        Set sortedGroups = (Set)stream.readObject();
        if (sortedGroups != null) {
            this.resourceGroups.addAll(sortedGroups);
            this.orderedListOfResGroups.addAll(sortedGroups);
        }
    }

    private static final class ResourceGroupComparator
    implements Comparator<ResourceGroup>,
    Serializable {
        private static final long serialVersionUID = -4939027384544021835L;

        private ResourceGroupComparator() {
        }

        @Override
        public int compare(ResourceGroup o1, ResourceGroup o2) {
            Long id1 = o1.getId();
            Long id2 = o2.getId();
            return id1.compareTo(id2);
        }
    }
}

