/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.search;

import com.tandbergtv.watchpoint.search.GroupingEntity;
import com.tandbergtv.watchpoint.search.HQLQuery;
import com.tandbergtv.watchpoint.search.Join;
import com.tandbergtv.watchpoint.search.NestedQueryEntity;
import com.tandbergtv.watchpoint.search.SearchParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SortParameter;
import java.util.ArrayList;
import java.util.List;

public class Entity
extends SearchParameter {
    protected List<SearchParameter> subparameters;
    protected Class<?> clazz;
    protected String property;
    protected boolean fetch;
    protected Join join;
    protected List<String> selectPropertyNames;

    public Entity(String name, Class<?> clazz, String alias) {
        super(name);
        this.clazz = clazz;
        this.subparameters = new ArrayList<SearchParameter>();
        this.alias = alias;
        this.fetch = true;
        this.join = Join.INNER;
        this.selectPropertyNames = new ArrayList<String>();
    }

    public Entity(String name, String property, String alias) {
        super(name);
        this.property = property;
        this.subparameters = new ArrayList<SearchParameter>();
        this.alias = alias;
        this.join = Join.INNER;
        this.selectPropertyNames = new ArrayList<String>();
    }

    public Class<?> getEntityClass() {
        return this.clazz;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isFetch() {
        return this.fetch;
    }

    public void setFetch(boolean fetch) {
        this.fetch = fetch;
    }

    public Join getJoin() {
        return this.join;
    }

    public void setJoin(Join join) {
        this.join = join;
    }

    public List<SearchParameter> getSubParameters() {
        return this.subparameters;
    }

    public String getSelectClause() {
        if (!this.fetch) {
            return "";
        }
        String clause = this.getSelectedNames();
        for (SearchParameter subparameter : this.getSubParameters()) {
            Entity e;
            if (subparameter instanceof NestedQueryEntity || !(subparameter instanceof Entity) || !(e = (Entity)Entity.class.cast(subparameter)).isFetch()) continue;
            clause = String.valueOf(clause) + ", " + e.getSelectedNames();
        }
        return clause;
    }

    protected String getSelectedNames() {
        String alias = this.getCompleteAlias();
        if (this.selectPropertyNames != null && this.selectPropertyNames.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String paramName : this.selectPropertyNames) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(alias) + "." + paramName);
            }
            return sb.toString();
        }
        return alias;
    }

    @Override
    public String getPartialFromClause(int count) {
        String clause = "";
        this.setObjectCount(count);
        for (SearchParameter subparameter : this.subparameters) {
            String partialWhere;
            if (subparameter instanceof NestedQueryEntity || !(subparameter instanceof Entity)) continue;
            Entity e = (Entity)Entity.class.cast(subparameter);
            String name = String.valueOf(this.getCompleteAlias()) + (Object)((Object)HQLQuery.PERIOD) + e.getProperty();
            HQLQuery jointype = e.getJoin() == Join.INNER ? HQLQuery.INNER_JOIN : HQLQuery.LEFT_JOIN;
            clause = String.valueOf(clause) + System.getProperty("line.separator");
            clause = String.valueOf(clause) + (Object)((Object)jointype) + name + " " + e.getCompleteAlias();
            if (e.getJoin() != Join.LEFT_OUTER || (partialWhere = e.getPartialWhereClause()).length() <= 0) continue;
            clause = String.valueOf(clause) + (Object)((Object)HQLQuery.WITH) + partialWhere;
        }
        return String.valueOf(this.clazz.getName()) + " " + this.alias + this.objectCount + clause;
    }

    @Override
    public String getPartialWhereClause() {
        String clause = "";
        SearchParameter prev = null;
        for (SearchParameter subparameter : this.subparameters) {
            Entity e;
            if (subparameter.getDecoratedParameter() instanceof SortParameter || subparameter instanceof Entity && (e = (Entity)Entity.class.cast(subparameter)).getJoin() == Join.LEFT_OUTER) continue;
            if (!(subparameter instanceof GroupingEntity && ((GroupingEntity)subparameter).isClosed() || prev != null && prev instanceof GroupingEntity && ((GroupingEntity)prev).isOpen() || clause.length() <= 0)) {
                clause = subparameter.isConjunction() ? String.valueOf(clause) + System.getProperty("line.separator") + "\t" + (Object)((Object)HQLQuery.AND) : String.valueOf(clause) + System.getProperty("line.separator") + "\t" + (Object)((Object)HQLQuery.OR);
            }
            prev = subparameter;
            clause = String.valueOf(clause) + subparameter.getPartialWhereClause();
        }
        return clause;
    }

    @Override
    public String getPartialOrderByClause() {
        String clause = "";
        for (SearchParameter parameter : this.getSubParameters()) {
            if (parameter instanceof Entity) {
                clause = String.valueOf(clause) + parameter.getPartialOrderByClause();
                continue;
            }
            if (!(parameter.getDecoratedParameter() instanceof SortParameter)) continue;
            if (clause.length() > 0) {
                clause = String.valueOf(clause) + ", ";
            }
            clause = String.valueOf(clause) + this.getCompleteAlias() + (Object)((Object)HQLQuery.PERIOD) + parameter.getPartialOrderByClause();
        }
        return clause;
    }

    @Override
    public void setObjectCount(int count) {
        this.objectCount = count;
        for (SearchParameter subparameter : this.subparameters) {
            if (subparameter instanceof NestedQueryEntity) {
                subparameter.setObjectCount(this.objectCount);
                continue;
            }
            if (subparameter instanceof Entity) {
                subparameter.setObjectCount(count++);
                continue;
            }
            subparameter.setObjectCount(this.objectCount);
        }
    }

    public void addParameter(SearchParameterBase parameter) {
        SearchParameter subparameter = null;
        if (parameter instanceof SearchParameter) {
            subparameter = (SearchParameter)parameter;
        } else {
            subparameter = new SearchParameter(parameter);
            subparameter.setAlias(this.alias);
        }
        this.subparameters.add(subparameter);
    }

    public void addParameter(SearchParameterBase parameter, boolean isConjunction) {
        SearchParameter subparameter = null;
        if (parameter instanceof SearchParameter) {
            subparameter = (SearchParameter)parameter;
        } else {
            subparameter = new SearchParameter(parameter);
            subparameter.setAlias(this.alias);
        }
        subparameter.setConjunction(isConjunction);
        this.subparameters.add(subparameter);
    }

    public List<String> getSelectPropertyNames() {
        return this.selectPropertyNames;
    }

    public void setSelectPropertyNames(List<String> selectPropertyNames) {
        this.selectPropertyNames = selectPropertyNames;
    }
}

