/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.internal;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.partition.MigrationEvent;
import com.hazelcast.partition.MigrationListener;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Cluster;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.core.service.cache.PartitionEvent;
import com.tandbergtv.workflow.core.service.internal.AbstractCompositeCache;
import com.tandbergtv.workflow.core.service.internal.DistributedCache;
import java.io.Serializable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CompositeCache<T>
extends AbstractCompositeCache<T> {
    public CompositeCache(String name, int size) {
        super(name, size);
    }

    @Override
    protected MigrationListener getMigrationListener() {
        return new CompositeCacheMigrationListener(this);
    }

    protected Map<Integer, Set<Serializable>> getMissingKeys() {
        HashMap<Integer, Set<Serializable>> partitions = new HashMap<Integer, Set<Serializable>>();
        for (Serializable key : this.localKeySet()) {
            if (this.cache.get(key) != null) continue;
            Integer partitionId = Cluster.getPartitionId(key);
            HashSet<Serializable> keys = (HashSet<Serializable>)partitions.get(partitionId);
            if (keys == null) {
                keys = new HashSet<Serializable>();
                partitions.put(partitionId, keys);
            }
            keys.add(key);
        }
        return partitions;
    }

    protected Set<Serializable> getKeysInPartition(int partitionId) {
        HashSet<Serializable> set = new HashSet<Serializable>();
        for (Serializable key : this.cache.getKeys()) {
            if (Cluster.getPartitionId(key) != partitionId) continue;
            set.add(key);
        }
        return set;
    }

    protected class CompositeCacheMembershipListener
    implements MembershipListener {
        protected IDistributedCache<T> cache;

        public CompositeCacheMembershipListener(IDistributedCache<T> cache) {
            this.cache = cache;
        }

        public void memberAdded(MembershipEvent e) {
        }

        public void memberRemoved(MembershipEvent e) {
            Map<Integer, Set<Serializable>> partitions = CompositeCache.this.getMissingKeys();
            for (Integer partitionId : partitions.keySet()) {
                MigrationEvent event = new MigrationEvent(this.cache, partitionId.intValue(), e.getMember(), Cluster.localMember());
                DefaultMediator.getInstance().sendAsync((WorkflowEvent)new PartitionEvent(this.cache, (EventObject)event, partitions.get(partitionId), true, false));
            }
        }
    }

    protected class CompositeCacheMigrationListener
    extends DistributedCache.CacheKeyMigrationListener {
        public CompositeCacheMigrationListener(IDistributedCache<T> cache) {
            super(CompositeCache.this, cache);
            Hazelcast.getCluster().addMembershipListener((MembershipListener)new CompositeCacheMembershipListener(cache));
        }

        @Override
        public void migrationStarted(MigrationEvent event) {
            if (this.wasPreviousOwner(event)) {
                Set<Serializable> set = CompositeCache.this.getKeysInPartition(event.getPartitionId());
                this.sendEvent(new PartitionEvent(this.cache, (EventObject)event, set, false));
            }
        }

        @Override
        public void migrationCompleted(MigrationEvent event) {
        }
    }
}

