/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.preferences.internal;

import com.tandbergtv.workflow.core.service.preferences.IUserPreferenceManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;

public class DefaultUserPreferenceManager
implements IUserPreferenceManager {
    private static final String PRODUCT_DIR_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final String PREFERENCES_FOLDER = "workflow" + File.separator + "preferences";

    @Override
    public void start() {
        String productFolder = System.getProperty(PRODUCT_DIR_PROPERTY);
        File preferencesFolder = new File(productFolder, PREFERENCES_FOLDER);
        if (!preferencesFolder.exists()) {
            preferencesFolder.mkdirs();
        }
        if (!preferencesFolder.exists() || !preferencesFolder.isDirectory()) {
            String path = preferencesFolder.getAbsolutePath();
            String message = "Path: " + path + " is not a valid folder, cannot manage user preferences.";
            throw new RuntimeException(message);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public String getServiceName() {
        return this.getClass().getName();
    }

    @Override
    public String getUserPreference(String userName, String preferenceKey) {
        return this.loadUserPreferences(userName).getProperty(preferenceKey);
    }

    @Override
    public void setUserPreference(String userName, String preferenceKey, String value) {
        Properties preferences = this.loadUserPreferences(userName);
        preferences.setProperty(preferenceKey, value);
        this.storeUserPreferences(userName, preferences);
    }

    @Override
    public void deleteUserPreference(String userName, String preferenceKey) {
        Properties preferences = this.loadUserPreferences(userName);
        if (preferences.containsKey(preferenceKey)) {
            preferences.remove(preferenceKey);
            this.storeUserPreferences(userName, preferences);
        }
    }

    @Override
    public Map<String, String> getUserPreferences(String userName) {
        HashMap<String, String> preferences = new HashMap<String, String>();
        Properties allPreferences = this.loadUserPreferences(userName);
        for (String key : allPreferences.stringPropertyNames()) {
            preferences.put(key, allPreferences.getProperty(key));
        }
        return preferences;
    }

    @Override
    public void setUserPreferences(String userName, Map<String, String> preferences) {
        Properties allPreferences = this.loadUserPreferences(userName);
        for (String key : preferences.keySet()) {
            allPreferences.setProperty(key, preferences.get(key));
        }
        this.storeUserPreferences(userName, allPreferences);
    }

    @Override
    public void deleteUserPreferences(String userName) {
        this.storeUserPreferences(userName, new Properties());
    }

    private Properties loadUserPreferences(String userName) {
        Properties preferences = new Properties();
        File preferencesFile = this.getUserPreferenceFile(userName);
        if (!preferencesFile.exists()) {
            return preferences;
        }
        boolean tryAgain = false;
        try {
            this.loadUserPreferences(preferencesFile, preferences);
        }
        catch (Exception e) {
            tryAgain = true;
        }
        if (tryAgain && preferencesFile.exists()) {
            try {
                this.loadUserPreferences(preferencesFile, preferences);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load user preferences for " + userName, e);
            }
        }
        return preferences;
    }

    private void loadUserPreferences(File preferencesFile, Properties preferences) throws InvalidPropertiesFormatException, IOException {
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(preferencesFile));
            preferences.loadFromXML(stream);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void storeUserPreferences(String userName, Properties preferences) {
        File preferencesFile = this.getUserPreferenceFile(userName);
        boolean tryAgain = false;
        try {
            this.storeUserPreferences(preferencesFile, preferences);
        }
        catch (Exception e) {
            tryAgain = true;
        }
        if (tryAgain) {
            try {
                this.storeUserPreferences(preferencesFile, preferences);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to store user preferences for " + userName + ", error: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private void storeUserPreferences(File preferencesFile, Properties userPreferences) throws IOException {
        int count = userPreferences.size();
        if (count > 0) {
            OutputStream stream = null;
            try {
                stream = new BufferedOutputStream(new FileOutputStream(preferencesFile));
                userPreferences.storeToXML(stream, null);
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (preferencesFile.exists()) {
            preferencesFile.delete();
        }
        if (preferencesFile.exists()) {
            throw new RuntimeException("Failed to delete preference file: " + preferencesFile.getAbsolutePath());
        }
    }

    private File getUserPreferenceFile(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("The user name cannot be null.");
        }
        String productFolder = System.getProperty(PRODUCT_DIR_PROPERTY);
        File preferencesFolder = new File(productFolder, PREFERENCES_FOLDER);
        String preferencesFileName = String.valueOf(userName) + ".xml";
        return new File(preferencesFolder, preferencesFileName);
    }
}

