/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.log.events.LogEventWrapper;
import com.tandbergtv.workflow.log.loggers.IWorkflowLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class LogQueueDrainer {
    private BlockingQueue<WorkflowEvent> queue;
    private ISchedulerService<Void> scheduler;
    private String name;
    private int index;
    private List<IWorkflowLogger> loggers;
    private List<WorkflowEvent> buffer;
    private int bufferSize;
    private long bufferDrainTimeout;
    private long bufferDrainStartTime;
    private boolean drainQueue = false;
    private SessionFactory sessionFactory;
    private final Statistics stats = new Statistics();
    private static final Logger logger = Logger.getLogger(LogQueueDrainer.class);

    public LogQueueDrainer(String prefix, int index, int bufferSize, int bufferDrainTimeout, SessionFactory factory, IWorkflowLogger ... loggers) {
        this.name = prefix + "[" + index + "]";
        this.index = index;
        this.queue = new LinkedBlockingQueue<WorkflowEvent>();
        this.loggers = Arrays.asList(loggers);
        this.scheduler = new Scheduler(this.name, 1, 1);
        this.buffer = new ArrayList<WorkflowEvent>();
        this.sessionFactory = factory;
        this.bufferSize = bufferSize;
        if (bufferDrainTimeout <= 0) {
            String error = "The buffer drain timeout must be greater than 0, invalid timeout: " + bufferDrainTimeout;
            throw new IllegalArgumentException(error);
        }
        this.bufferDrainTimeout = (long)bufferDrainTimeout * 1000L;
        this.bufferDrainStartTime = 0L;
    }

    public String getName() {
        return this.name;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public long getAverageDelay() {
        if (this.stats.saved == 0L) {
            return 0L;
        }
        return this.stats.delay / this.stats.saved;
    }

    public long getAverageQueueDelay() {
        if (this.stats.added == 0L) {
            return 0L;
        }
        return this.stats.queueDelay / this.stats.added;
    }

    public long getAdded() {
        return this.stats.added;
    }

    public int getMaxQueueSize() {
        return this.stats.max;
    }

    public void drainEvent(WorkflowEvent event) {
        boolean match = false;
        for (IWorkflowLogger wl : this.loggers) {
            match = match || wl.match((EventObject)event, this.index);
        }
        if (match) {
            this.queue.offer(new LogEventWrapper(new Date(), event));
            ++this.stats.added;
            int size = this.queue.size();
            if (size > this.stats.max) {
                this.stats.max = size;
            }
        }
    }

    public void start() {
        this.drainQueue = true;
        this.scheduler.start();
        this.scheduler.schedule((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                while (LogQueueDrainer.this.drainQueue) {
                    WorkflowEvent event;
                    long timeout = System.currentTimeMillis() - LogQueueDrainer.this.bufferDrainStartTime;
                    if (timeout > LogQueueDrainer.this.bufferDrainTimeout) {
                        timeout = LogQueueDrainer.this.bufferDrainTimeout;
                    }
                    if ((event = (WorkflowEvent)LogQueueDrainer.this.queue.poll(timeout, TimeUnit.MILLISECONDS)) != null) {
                        if (LogQueueDrainer.this.buffer.isEmpty()) {
                            LogQueueDrainer.this.startBufferDrainTimer();
                        }
                        LogQueueDrainer.this.buffer.add(event);
                    }
                    if (!LogQueueDrainer.this.mustDrainBuffer()) continue;
                    Session session = null;
                    try {
                        session = LogQueueDrainer.this.sessionFactory.getCurrentSession();
                        session.beginTransaction();
                        LogQueueDrainer.this.emptyBuffer();
                        session.getTransaction().commit();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to write logs", (Throwable)e);
                        if (session == null) continue;
                        session.getTransaction().rollback();
                    }
                    finally {
                        if (session == null || !session.isOpen()) continue;
                        session.close();
                    }
                }
                return null;
            }
        });
    }

    public void stop() {
        this.drainQueue = false;
        this.scheduler.stop();
    }

    private void startBufferDrainTimer() {
        this.bufferDrainStartTime = System.currentTimeMillis();
    }

    private void resetBufferDrainTimer() {
        this.bufferDrainStartTime = 0L;
    }

    private boolean isBufferDrainTimerExpired() {
        if (this.bufferDrainStartTime <= 0L) {
            return false;
        }
        long time = System.currentTimeMillis();
        return time - this.bufferDrainStartTime >= this.bufferDrainTimeout;
    }

    private boolean mustDrainBuffer() {
        return this.buffer.size() >= this.bufferSize || this.isBufferDrainTimerExpired();
    }

    private void emptyBuffer() {
        Iterator<WorkflowEvent> i = this.buffer.iterator();
        while (i.hasNext()) {
            LogEventWrapper wrapper = (LogEventWrapper)i.next();
            WorkflowEvent event = wrapper.getEvent();
            logger.debug((Object)("Log event: " + event));
            this.stats.queueDelay += System.currentTimeMillis() - wrapper.getQueuedDate().getTime();
            long start = System.currentTimeMillis();
            this.logEvent(event);
            long diff = System.currentTimeMillis() - start;
            this.stats.delay += diff;
            ++this.stats.saved;
            logger.debug((Object)("Saved " + event.getClass().getSimpleName() + " event in " + (double)diff / 1000.0 + " seconds"));
            i.remove();
        }
        this.resetBufferDrainTimer();
    }

    private void logEvent(WorkflowEvent event) {
        for (IWorkflowLogger wl : this.loggers) {
            try {
                wl.execute((EventObject)event);
            }
            catch (Throwable t) {
                logger.error((Object)("Throwable caught in executing the logger: " + this.name + " for event: " + event), t);
            }
        }
    }

    class Statistics {
        long saved;
        long delay;
        long queueDelay;
        long added;
        int max;

        Statistics() {
        }
    }
}

