/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.util.jpf;

import java.io.File;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.DefaultPluginsCollector;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.util.ExtendedProperties;

public class JPF {
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String PLUGINS_DIR = "workflow" + File.separator + "plugins";
    private static final String JPF_PLUGIN_REPOSITORY_PROPERTY = "org.java.plugin.boot.pluginsRepositories";
    private static final Logger logger = Logger.getLogger(JPF.class);

    public static PluginManager start() {
        logger.debug((Object)"Initializing the Java Plugin Framework...");
        ExtendedProperties properties = new ExtendedProperties(System.getProperties());
        String dir = System.getProperty(PRODUCT_DIR);
        properties.setProperty(JPF_PLUGIN_REPOSITORY_PROPERTY, dir + File.separator + PLUGINS_DIR);
        PluginManager pluginmanager = ObjectFactory.newInstance((ExtendedProperties)properties).createManager();
        DefaultPluginsCollector collector = new DefaultPluginsCollector();
        try {
            collector.configure(properties);
            Collection pluginLocations = collector.collectPluginLocations();
            pluginmanager.publishPlugins(pluginLocations.toArray(new PluginManager.PluginLocation[pluginLocations.size()]));
            IntegrityCheckReport report = pluginmanager.getRegistry().checkIntegrity(pluginmanager.getPathResolver(), true);
            for (IntegrityCheckReport.ReportItem item : report.getItems()) {
                if (item.getSeverity() != IntegrityCheckReport.Severity.ERROR) continue;
                logger.debug((Object)item.getMessage());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to initialize plugins", ex);
        }
        logger.info((Object)"Successfully initialized plugins");
        return pluginmanager;
    }

    public static void stop(PluginManager pluginmanager) {
        if (pluginmanager != null) {
            pluginmanager.shutdown();
        }
        pluginmanager = null;
    }
}

