/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.monitor;

import com.hazelcast.config.Config;
import com.hazelcast.config.TcpIpConfig;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ClusterConfiguration {
    private static final String HAZELCAST_DISCOVERY_TYPE = "discovery.type";
    private static final String HAZELCAST_MULTICAST_GROUP = "multicast.ip";
    private static final String HAZELCAST_MULTICAST_PORT = "multicast.port";
    private static final String HAZELCAST_TCPIP_HOSTS = "tcpip.hosts";
    private static final String HAZELCAST_HOST_IP = "host.ip";
    private static final String HAZELCAST_CLUSTER_NAME = "cluster.name";
    private static final String HAZELCAST_CLUSTER_PASSWORD = "cluster.password";
    private static final String HAZELCAST_INITIAL_WAIT = "initial.wait";
    private static final Logger log = Logger.getLogger(ClusterConfiguration.class);

    private ClusterConfiguration() {
    }

    public static Config create(Properties properties) throws IOException {
        System.setProperty("hazelcast.logging.type", "log4j");
        Config config = new Config();
        ClusterConfiguration.configureClusterDiscovery(config, properties);
        ClusterConfiguration.configureClusterHost(config, properties);
        ClusterConfiguration.configureClusterName(config, properties);
        ClusterConfiguration.configureInitialWait(config, properties);
        return config;
    }

    private static void configureInitialWait(Config config, Properties properties) throws IOException {
        String wait = properties.getProperty(HAZELCAST_INITIAL_WAIT);
        if (wait != null) {
            config.setProperty("hazelcast.initial.wait.seconds", wait);
        }
    }

    private static void configureClusterName(Config config, Properties properties) throws IOException {
        String password;
        String name = properties.getProperty(HAZELCAST_CLUSTER_NAME);
        if (name != null) {
            log.debug((Object)("Cluster name " + name));
            config.getGroupConfig().setName(name);
        }
        if ((password = properties.getProperty(HAZELCAST_CLUSTER_PASSWORD)) != null) {
            config.getGroupConfig().setPassword(password);
        }
    }

    private static void configureClusterHost(Config config, Properties properties) throws IOException {
        config.getNetworkConfig().getInterfaces().clear();
        String host = properties.getProperty(HAZELCAST_HOST_IP);
        if (host == null) {
            host = ClusterConfiguration.getAddress().getHostAddress();
        }
        log.debug((Object)("Cluster host " + host));
        config.getNetworkConfig().getInterfaces().addInterface(host);
        config.getNetworkConfig().getInterfaces().setEnabled(true);
    }

    private static void configureClusterDiscovery(Config config, Properties properties) {
        String discoveryType = properties.getProperty(HAZELCAST_DISCOVERY_TYPE);
        log.debug((Object)("Hazelcast discovery type: " + discoveryType));
        if ("tcpip".equalsIgnoreCase(discoveryType)) {
            ClusterConfiguration.configureTcpIpDiscovery(config, properties);
        } else {
            ClusterConfiguration.configureMulticastDiscovery(config, properties);
        }
    }

    private static void configureMulticastDiscovery(Config config, Properties properties) {
        String port;
        log.debug((Object)"Configuring multicast cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(true);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(false);
        String ip = properties.getProperty(HAZELCAST_MULTICAST_GROUP);
        if (ip != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastGroup(ip);
            log.debug((Object)("Cluster multicast group: " + ip));
        }
        if ((port = properties.getProperty(HAZELCAST_MULTICAST_PORT)) != null) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setMulticastPort(Integer.parseInt(port));
            log.debug((Object)("Cluster multicast port: " + port));
        }
    }

    private static void configureTcpIpDiscovery(Config config, Properties properties) {
        log.debug((Object)"Configuring TCP/IP cluster discovery.");
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().getJoin().getTcpIpConfig().setEnabled(true);
        TcpIpConfig tcpip = config.getNetworkConfig().getJoin().getTcpIpConfig();
        String hosts = properties.getProperty(HAZELCAST_TCPIP_HOSTS);
        if (hosts != null) {
            StringTokenizer tkz = new StringTokenizer(hosts, ",; ");
            while (tkz.hasMoreTokens()) {
                String host = tkz.nextToken();
                try {
                    log.debug((Object)("Adding host: " + host));
                    tcpip.addMember(host);
                }
                catch (Exception ex) {
                    log.error((Object)("Could not add host: " + host), (Throwable)ex);
                }
            }
        }
    }

    private static InetAddress getAddress() throws IOException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                return address;
            }
        }
        return InetAddress.getLocalHost();
    }
}

