/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log.entities;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.proxy.CustomTokenProxy;
import com.tandbergtv.workflow.resourcemanager.entities.Resource;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.lang.reflect.Field;
import java.util.Date;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.Token;
import org.jbpm.logging.log.ProcessLog;

public class ProcessStatusPerResourceLog
extends ProcessLog {
    private static final long serialVersionUID = 1L;
    protected long nodeId;
    protected long resourceGroupId;
    protected Long resourceId;
    protected Date startTime;
    protected Date endTime;
    protected ProcessStatus operationalStatus;
    protected ProcessStatus adminStatus;

    public ProcessStatusPerResourceLog() {
    }

    public ProcessStatusPerResourceLog(Token token, Node node, ResourceGroup resourceGroup, Resource resource, Date start, Date end, ProcessStatus status, ProcessStatus adminStatus) {
        this.token = token;
        if (token instanceof CustomTokenProxy) {
            this.token = this.getToken(token.getId());
        }
        this.nodeId = node.getId();
        this.resourceGroupId = resourceGroup.getId();
        if (resource != null) {
            this.resourceId = resource.getId();
        }
        this.startTime = start;
        this.endTime = end;
        this.operationalStatus = status;
        this.adminStatus = adminStatus;
    }

    public ProcessStatus getAdminStatus() {
        return this.adminStatus;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public ProcessStatus getOperationalStatus() {
        return this.operationalStatus;
    }

    public Long getResourceId() {
        return this.resourceId;
    }

    public long getResourceGroupId() {
        return this.resourceGroupId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    private Token getToken(long id) {
        Token token = new Token();
        try {
            Field field = token.getClass().getDeclaredField("id");
            field.setAccessible(true);
            field.set(token, id);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        return token;
    }

    public void setTokenId(long id) {
        this.setToken(this.getToken(id));
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public void setResourceGroupId(long resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setOperationalStatus(ProcessStatus operationalStatus) {
        this.operationalStatus = operationalStatus;
    }

    public void setAdminStatus(ProcessStatus adminStatus) {
        this.adminStatus = adminStatus;
    }

    public String toString() {
        return "Status Entry: [token:" + this.getToken().getId() + " node:" + this.nodeId + " resourcegroup:" + this.resourceGroupId + " resource:" + this.resourceId + " startTime:" + this.getStartTime() + " endTime:" + this.getEndTime() + " operationalStatus:" + this.getOperationalStatus().name() + " adminStatus:" + this.getAdminStatus().name() + "]";
    }
}

