/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.log;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.log.EventSerializer;
import com.tandbergtv.workflow.log.Finder;
import com.tandbergtv.workflow.log.LogEventListener;
import com.tandbergtv.workflow.log.SortColumnEnum;
import com.tandbergtv.workflow.log.entities.MessageLog;
import com.tandbergtv.workflow.log.file.Directories;
import com.tandbergtv.workflow.log.file.GarbageCollector;
import com.tandbergtv.workflow.log.file.LogReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.logging.log.ProcessLog;

public class WorkflowLogService
implements Service {
    private LogEventListener listener;
    private GarbageCollector collector;
    private Scheduler<Void> scheduler;
    private String dir;
    private long period;

    public WorkflowLogService(SessionFactory factory, String rootdir, Long period, Long window) {
        Finder finder = new Finder(factory);
        this.listener = new LogEventListener(new EventSerializer(rootdir));
        this.collector = new GarbageCollector(rootdir, window, finder);
        this.scheduler = new Scheduler("log-delete", 1, 1);
        this.period = period;
        this.dir = rootdir;
    }

    public void start() {
        DefaultMediator.getInstance().register((IColleague)this.listener);
    }

    public void startGCOnMaster() {
        this.scheduler.start();
        this.scheduler.schedule((Runnable)this.collector, 0L, this.period * 1000L);
    }

    public void stop() {
        this.scheduler.stop();
        DefaultMediator.getInstance().unregister((IColleague)this.listener);
    }

    public String getServiceName() {
        return "process-logger";
    }

    public List<NodeLog> findNodeLogs(WorkflowTemplate template, long processId, int start, int count) {
        if (!this.hasLogs(processId)) {
            return Collections.emptyList();
        }
        if (count == 0) {
            start = 0;
            count = 25;
        }
        List<ProcessLog> list = this.getLogs(processId, NodeLog.class, this.nodeIds(template), start, count, false);
        return this.getNodeLogs(list);
    }

    public int getNodeLogCount(WorkflowTemplate template, long processId) {
        if (!this.hasLogs(processId)) {
            return 0;
        }
        return this.getLogsCount(processId, NodeLog.class, this.nodeIds(template));
    }

    public List<MessageLog> findMessageLogs(long id, long nodeId, long logid, int count, int start, String orderBy, final boolean descending) {
        if (!this.hasLogs(id)) {
            return Collections.emptyList();
        }
        if (count == 0) {
            count = Integer.MAX_VALUE;
        }
        List<MessageLog> list = this.getMessageLogs(id, nodeId, logid, 0, Integer.MAX_VALUE);
        final SortColumnEnum order = orderBy == null ? SortColumnEnum.timestamp : SortColumnEnum.valueOf(orderBy);
        Collections.sort(list, new Comparator<MessageLog>(){

            @Override
            public int compare(MessageLog m1, MessageLog m2) {
                return MessageLog.compare(m1, m2, order, descending);
            }
        });
        return this.subList(list, start, count);
    }

    public int getMessageLogsCount(long id, long nodeId, long logid) {
        if (!this.hasLogs(id)) {
            return 0;
        }
        return this.getMessageLogs(id, nodeId, logid, 0, Integer.MAX_VALUE).size();
    }

    public long getCurrentNodeMessageLogId(long id, long nodeId) {
        if (!this.hasLogs(id)) {
            return 0L;
        }
        List<ProcessLog> logs = this.getLogs(id, MessageLog.class, new HashSet<Long>(Arrays.asList(nodeId)), 0, 1, true);
        if (logs.isEmpty()) {
            return 0L;
        }
        return logs.get(0).getId();
    }

    public int[] getTaskNodeIteration(long id, long nodeId, long logid) {
        if (!this.hasLogs(id)) {
            return new int[]{0, 0};
        }
        List<ProcessLog> logs = this.getLogs(id, NodeLog.class, new HashSet<Long>(Arrays.asList(nodeId)), 0, Integer.MAX_VALUE, false);
        return new int[]{logs.indexOf(this.findById(logs, logid)) + 1, logs.size()};
    }

    private List<MessageLog> getMessageLogs(long id, long nodeId, long time, int start, int count) {
        ArrayList<MessageLog> logs = new ArrayList<MessageLog>();
        List<ProcessLog> list = this.getLogs(id, this.types(), new HashSet<Long>(Arrays.asList(nodeId)), start, count, true);
        ProcessLog log = this.findById(list, time);
        int index = list.indexOf(log);
        for (int i = index + 1; i < list.size(); ++i) {
            ProcessLog l = list.get(i);
            if (l instanceof NodeLog) {
                return logs;
            }
            logs.add((MessageLog)((Object)MessageLog.class.cast(l)));
        }
        return logs;
    }

    private ProcessLog findById(List<ProcessLog> logs, long id) {
        for (ProcessLog log : logs) {
            if (!(log instanceof NodeLog) || log.getId() != id) continue;
            return log;
        }
        return null;
    }

    private Set<Long> nodeIds(WorkflowTemplate template) {
        final HashSet<Long> set = new HashSet<Long>();
        template.breadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                set.add(node.getId());
            }
        });
        return set;
    }

    private Collection<Class<? extends ProcessLog>> types() {
        HashSet<Class<? extends ProcessLog>> types = new HashSet<Class<? extends ProcessLog>>();
        types.add(NodeLog.class);
        types.add(MessageLog.class);
        return types;
    }

    private List<NodeLog> getNodeLogs(List<ProcessLog> list) {
        ArrayList<NodeLog> copy = new ArrayList<NodeLog>();
        for (ProcessLog log : list) {
            copy.add((NodeLog)log);
        }
        return copy;
    }

    private int getLogsCount(long id, Class<? extends ProcessLog> type, Set<Long> nodeIds) {
        return new LogReader(this.dir).count(id, type, nodeIds);
    }

    private List<ProcessLog> getLogs(long id, Class<? extends ProcessLog> type, Set<Long> nodeIds, int start, int count, boolean descending) {
        return new LogReader(this.dir).getLogs(id, type, nodeIds, start, count, descending);
    }

    private List<ProcessLog> getLogs(long id, Collection<Class<? extends ProcessLog>> types, Set<Long> nodeIds, int start, int count, boolean descending) {
        return new LogReader(this.dir).getLogs(id, types, nodeIds, start, count, descending);
    }

    public boolean hasLogs(long id) {
        File f = Directories.directoryFor(this.dir, id);
        return f.exists() && f.isDirectory();
    }

    private List<?> subList(List<?> list, int start, int count) {
        int end = list.size() - start < count ? list.size() : start + count;
        return list.subList(start, end);
    }
}

