/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.command;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.command.BaseTokenCommand;
import com.tandbergtv.workflow.driver.event.message.TaskCompleteEvent;
import com.tandbergtv.workflow.driver.service.IMessageQueueService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.command.CommandException;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.taskmgmt.exe.TaskMgmtInstance;

public class TaskCompleteCommand
extends BaseTokenCommand {
    private static final long serialVersionUID = 4386596988441541175L;
    private static final Logger logger = Logger.getLogger(TaskCompleteCommand.class);

    public TaskCompleteCommand(WorkflowMessage message) {
        super(message);
    }

    @Override
    protected WorkflowMessage executeImpl(Token token) {
        try {
            if (token.getNode() instanceof ManualTaskNode) {
                TaskInstance ti = this.getTaskInstance(token);
                if (ti == null) {
                    return this.createErrorResponse("No suitable manual task found");
                }
                this.copyVariables(ti);
                if (this.message.getType() == WorkflowMessage.MessageType.nack) {
                    ((CustomToken)token).fail(ErrorCategory.NACK, (String)this.message.getParameterValue("error-message"));
                } else {
                    ti.end();
                }
            } else {
                IMessageQueueService service = (IMessageQueueService)ServiceRegistry.getDefault().lookup(IMessageQueueService.class);
                service.addMessage(token, this.message);
            }
        }
        catch (CommandException e) {
            return this.createErrorResponse(e.getMessage());
        }
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new TaskCompleteEvent((Object)this, token, this.message));
        return this.createSuccessResponse();
    }

    private TaskInstance getTaskInstance(Token token) {
        Collection instances;
        TaskMgmtInstance tmi = token.getProcessInstance().getTaskMgmtInstance();
        if (tmi != null && (instances = tmi.getTaskInstances()) != null) {
            for (TaskInstance ti : instances) {
                if (ti.hasEnded() || !token.equals((Object)ti.getToken())) continue;
                return ti;
            }
        }
        return null;
    }

    private void copyVariables(TaskInstance ti) {
        List variables = ti.getTask().getTaskController().getVariableAccesses();
        for (TaskVariable variable : variables) {
            String name = variable.getMappedName();
            logger.debug((Object)(ti.getToken() + ", variable " + name));
            if (!variable.isWritable()) continue;
            Object value = this.message.getParameterValue(name);
            logger.debug((Object)(ti.getToken() + ", value " + value));
            if (value == null) continue;
            ti.setVariable(name, value);
        }
    }
}

